/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jei.registry;

import dev.hytalemod.jei.registry.ItemInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ItemRegistry {
    private final Map<String, ItemInfo> itemsById = new ConcurrentHashMap<String, ItemInfo>();
    private final Map<String, List<ItemInfo>> itemsByCategory = new ConcurrentHashMap<String, List<ItemInfo>>();
    private List<ItemInfo> sortedItems = new ArrayList<ItemInfo>();
    private final Map<String, List<ItemInfo>> searchCache = new LinkedHashMap<String, List<ItemInfo>>(this, 100, 0.75f, true){
        final /* synthetic */ ItemRegistry this$0;
        {
            ItemRegistry itemRegistry = this$0;
            Objects.requireNonNull(itemRegistry);
            this.this$0 = itemRegistry;
            super(arg0, arg1, arg2);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<ItemInfo>> eldest) {
            return this.size() > 100;
        }
    };
    private static final int MAX_CACHE_SIZE = 100;

    public void scanAllItems() {
        System.out.println("[HytaleJEI] Scanning item registries...");
        this.itemsById.clear();
        this.itemsByCategory.clear();
        this.searchCache.clear();
        this.scanHytaleItems();
        this.scanHytaleBlocks();
        this.sortedItems = new ArrayList<ItemInfo>(this.itemsById.values());
        this.sortedItems.sort(Comparator.comparing(ItemInfo::getName));
        System.out.println("[HytaleJEI] Found " + this.itemsById.size() + " items.");
    }

    private void scanHytaleItems() {
        this.registerItem(ItemInfo.builder("hytale:wooden_sword", "Wooden Sword").description("A basic wooden sword").category("weapons").maxStackSize(1).addTag("weapon").addTag("sword").addTag("melee").addTag("wood").build());
        this.registerItem(ItemInfo.builder("hytale:stone_sword", "Stone Sword").description("A stone sword").category("weapons").maxStackSize(1).addTag("weapon").addTag("sword").addTag("melee").addTag("stone").build());
        this.registerItem(ItemInfo.builder("hytale:iron_sword", "Iron Sword").description("A sturdy iron sword").category("weapons").maxStackSize(1).addTag("weapon").addTag("sword").addTag("melee").addTag("iron").addTag("metal").build());
        this.registerItem(ItemInfo.builder("hytale:wooden_pickaxe", "Wooden Pickaxe").description("A basic pickaxe for mining").category("tools").maxStackSize(1).addTag("tool").addTag("pickaxe").addTag("mining").addTag("wood").build());
        this.registerItem(ItemInfo.builder("hytale:stone_pickaxe", "Stone Pickaxe").description("A stone pickaxe").category("tools").maxStackSize(1).addTag("tool").addTag("pickaxe").addTag("mining").addTag("stone").build());
        this.registerItem(ItemInfo.builder("hytale:iron_pickaxe", "Iron Pickaxe").description("An iron pickaxe for mining ore").category("tools").maxStackSize(1).addTag("tool").addTag("pickaxe").addTag("mining").addTag("iron").addTag("metal").build());
        this.registerItem(ItemInfo.builder("hytale:apple", "Apple").description("A fresh apple that restores hunger").category("food").maxStackSize(64).addTag("food").addTag("fruit").addTag("healing").build());
        this.registerItem(ItemInfo.builder("hytale:bread", "Bread").description("Freshly baked bread").category("food").maxStackSize(64).addTag("food").addTag("baked").build());
        this.registerItem(ItemInfo.builder("hytale:iron_ingot", "Iron Ingot").description("A refined iron ingot").category("materials").maxStackSize(64).addTag("material").addTag("metal").addTag("iron").addTag("ingot").build());
        this.registerItem(ItemInfo.builder("hytale:gold_ingot", "Gold Ingot").description("A shiny gold ingot").category("materials").maxStackSize(64).addTag("material").addTag("metal").addTag("gold").addTag("ingot").addTag("precious").build());
        this.registerItem(ItemInfo.builder("hytale:copper_ingot", "Copper Ingot").description("A copper ingot").category("materials").maxStackSize(64).addTag("material").addTag("metal").addTag("copper").addTag("ingot").build());
        this.registerItem(ItemInfo.builder("hytale:stick", "Stick").description("A wooden stick").category("materials").maxStackSize(64).addTag("material").addTag("wood").addTag("crafting").build());
    }

    private void scanHytaleBlocks() {
        this.registerItem(ItemInfo.builder("hytale:stone", "Stone").description("Basic stone block").category("blocks").maxStackSize(64).addTag("block").addTag("natural").addTag("stone").build());
        this.registerItem(ItemInfo.builder("hytale:dirt", "Dirt").description("A block of dirt").category("blocks").maxStackSize(64).addTag("block").addTag("natural").addTag("dirt").build());
        this.registerItem(ItemInfo.builder("hytale:grass_block", "Grass Block").description("A dirt block with grass on top").category("blocks").maxStackSize(64).addTag("block").addTag("natural").addTag("grass").build());
        this.registerItem(ItemInfo.builder("hytale:oak_log", "Oak Log").description("A log from an oak tree").category("blocks").maxStackSize(64).addTag("block").addTag("wood").addTag("log").addTag("oak").build());
        this.registerItem(ItemInfo.builder("hytale:oak_planks", "Oak Planks").description("Wooden planks from oak").category("blocks").maxStackSize(64).addTag("block").addTag("wood").addTag("planks").addTag("oak").build());
        this.registerItem(ItemInfo.builder("hytale:cobblestone", "Cobblestone").description("Rough cobblestone").category("blocks").maxStackSize(64).addTag("block").addTag("stone").addTag("cobble").build());
        this.registerItem(ItemInfo.builder("hytale:iron_ore", "Iron Ore").description("Ore containing iron").category("blocks").maxStackSize(64).addTag("block").addTag("ore").addTag("iron").addTag("mining").build());
        this.registerItem(ItemInfo.builder("hytale:gold_ore", "Gold Ore").description("Ore containing gold").category("blocks").maxStackSize(64).addTag("block").addTag("ore").addTag("gold").addTag("mining").addTag("precious").build());
        this.registerItem(ItemInfo.builder("hytale:copper_ore", "Copper Ore").description("Ore containing copper").category("blocks").maxStackSize(64).addTag("block").addTag("ore").addTag("copper").addTag("mining").build());
        this.registerItem(ItemInfo.builder("hytale:crafting_table", "Crafting Table").description("Used to craft items").category("blocks").maxStackSize(64).addTag("block").addTag("utility").addTag("crafting").build());
        this.registerItem(ItemInfo.builder("hytale:furnace", "Furnace").description("Used to smelt ores and cook food").category("blocks").maxStackSize(64).addTag("block").addTag("utility").addTag("smelting").build());
        this.registerItem(ItemInfo.builder("hytale:chest", "Chest").description("Storage container").category("blocks").maxStackSize(64).addTag("block").addTag("utility").addTag("storage").build());
        this.registerItem(ItemInfo.builder("hytale:sand", "Sand").description("Sandy block").category("blocks").maxStackSize(64).addTag("block").addTag("natural").addTag("sand").build());
        this.registerItem(ItemInfo.builder("hytale:glass", "Glass").description("Transparent glass block").category("blocks").maxStackSize(64).addTag("block").addTag("transparent").addTag("glass").build());
    }

    public void registerItem(ItemInfo item) {
        this.itemsById.put(item.getId(), item);
        this.itemsByCategory.computeIfAbsent(item.getCategory(), k -> new ArrayList()).add(item);
    }

    public ItemInfo getItem(String id) {
        return this.itemsById.get(id);
    }

    public List<ItemInfo> getAllItems() {
        return new ArrayList<ItemInfo>(this.sortedItems);
    }

    public List<ItemInfo> getItemsByCategory(String category) {
        return new ArrayList<ItemInfo>(this.itemsByCategory.getOrDefault(category, Collections.emptyList()));
    }

    public Set<String> getCategories() {
        return new HashSet<String>(this.itemsByCategory.keySet());
    }

    public List<ItemInfo> search(String query) {
        if (query == null || query.isEmpty()) {
            return this.getAllItems();
        }
        String normalizedQuery = query.toLowerCase().trim();
        List<ItemInfo> cached = this.searchCache.get(normalizedQuery);
        if (cached != null) {
            return new ArrayList<ItemInfo>(cached);
        }
        List<ItemInfo> results = this.sortedItems.stream().filter(item -> item.matchesSearch(normalizedQuery)).collect(Collectors.toList());
        this.searchCache.put(normalizedQuery, results);
        return results;
    }

    public List<ItemInfo> getPage(List<ItemInfo> items, int page, int pageSize) {
        int start = page * pageSize;
        int end = Math.min(start + pageSize, items.size());
        if (start >= items.size()) {
            return Collections.emptyList();
        }
        return items.subList(start, end);
    }

    public int getItemCount() {
        return this.itemsById.size();
    }

    public void clearSearchCache() {
        this.searchCache.clear();
    }
}

