/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jei.registry;

import java.util.ArrayList;
import java.util.List;

public class ItemInfo {
    private final String id;
    private final String name;
    private final String description;
    private final String category;
    private final String iconPath;
    private final int maxStackSize;
    private final List<String> tags;

    private ItemInfo(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.category = builder.category;
        this.iconPath = builder.iconPath;
        this.maxStackSize = builder.maxStackSize;
        this.tags = new ArrayList<String>(builder.tags);
    }

    public static Builder builder(String id, String name) {
        return new Builder(id, name);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public List<String> getTags() {
        return new ArrayList<String>(this.tags);
    }

    public boolean matchesSearch(String query) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        String lowerQuery = query.toLowerCase().trim();
        if (this.id.toLowerCase().contains(lowerQuery)) {
            return true;
        }
        if (this.name.toLowerCase().contains(lowerQuery)) {
            return true;
        }
        if (this.description.toLowerCase().contains(lowerQuery)) {
            return true;
        }
        if (this.category.toLowerCase().contains(lowerQuery)) {
            return true;
        }
        for (String tag : this.tags) {
            if (!tag.toLowerCase().contains(lowerQuery)) continue;
            return true;
        }
        if (lowerQuery.startsWith("@")) {
            String catQuery = lowerQuery.substring(1);
            return this.category.toLowerCase().contains(catQuery);
        }
        if (lowerQuery.startsWith("#")) {
            String tagQuery = lowerQuery.substring(1);
            for (String tag : this.tags) {
                if (!tag.toLowerCase().contains(tagQuery)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return "ItemInfo{id='" + this.id + "', name='" + this.name + "'}";
    }

    public static class Builder {
        private final String id;
        private final String name;
        private String description = "";
        private String category = "misc";
        private String iconPath = "";
        private int maxStackSize = 64;
        private List<String> tags = new ArrayList<String>();

        public Builder(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder description(String desc) {
            this.description = desc;
            return this;
        }

        public Builder category(String cat) {
            this.category = cat;
            return this;
        }

        public Builder iconPath(String path) {
            this.iconPath = path;
            return this;
        }

        public Builder maxStackSize(int size) {
            this.maxStackSize = size;
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public ItemInfo build() {
            return new ItemInfo(this);
        }
    }
}

