/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jei.command;

import dev.hytalemod.jei.HytaleJEIPlugin;
import dev.hytalemod.jei.registry.ItemInfo;
import java.util.List;

public class JEICommand {
    private final HytaleJEIPlugin plugin;

    public JEICommand(HytaleJEIPlugin plugin) {
        this.plugin = plugin;
    }

    public void execute(Object sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.openScreen(sender);
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "search": 
            case "s": {
                this.handleSearch(sender, args);
                break;
            }
            case "info": 
            case "i": {
                this.handleInfo(sender, args);
                break;
            }
            case "reload": 
            case "r": {
                this.handleReload(sender);
                break;
            }
            case "list": 
            case "l": {
                this.handleList(sender, args);
                break;
            }
            case "help": 
            case "?": {
                this.showHelp(sender);
                break;
            }
            default: {
                String query = String.join((CharSequence)" ", args);
                this.plugin.openJEIScreenWithSearch(sender, query);
            }
        }
    }

    private void openScreen(Object sender) {
        this.plugin.openJEIScreen(sender);
        this.sendMessage(sender, "\u00a7aOpening JEI...");
    }

    private void handleSearch(Object sender, String[] args) {
        if (args.length < 2) {
            this.plugin.openJEIScreen(sender);
            return;
        }
        StringBuilder query = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                query.append(" ");
            }
            query.append(args[i]);
        }
        this.plugin.openJEIScreenWithSearch(sender, query.toString());
    }

    private void handleInfo(Object sender, String[] args) {
        if (args.length < 2) {
            this.sendMessage(sender, "\u00a7cUsage: /jei info <item_id>");
            return;
        }
        String itemId = args[1];
        ItemInfo item = this.plugin.getItemRegistry().getItem(itemId);
        if (item == null) {
            item = this.plugin.getItemRegistry().getItem("hytale:" + itemId);
        }
        if (item == null) {
            this.sendMessage(sender, "\u00a7cItem not found: " + itemId);
            return;
        }
        this.sendMessage(sender, "\u00a76=== " + item.getName() + " ===");
        this.sendMessage(sender, "\u00a77ID: \u00a7f" + item.getId());
        this.sendMessage(sender, "\u00a77Category: \u00a7f" + item.getCategory());
        this.sendMessage(sender, "\u00a77Max Stack: \u00a7f" + item.getMaxStackSize());
        if (!item.getDescription().isEmpty()) {
            this.sendMessage(sender, "\u00a77Description: \u00a7f" + item.getDescription());
        }
        if (!item.getTags().isEmpty()) {
            this.sendMessage(sender, "\u00a77Tags: \u00a7f" + String.join((CharSequence)", ", item.getTags()));
        }
    }

    private void handleList(Object sender, String[] args) {
        List<ItemInfo> items;
        String category;
        String string = category = args.length > 1 ? args[1] : null;
        if (category != null) {
            items = this.plugin.getItemRegistry().getItemsByCategory(category);
            if (items.isEmpty()) {
                this.sendMessage(sender, "\u00a7cNo items found in category: " + category);
                this.sendMessage(sender, "\u00a77Available categories: " + String.join((CharSequence)", ", this.plugin.getItemRegistry().getCategories()));
                return;
            }
            this.sendMessage(sender, "\u00a76=== Items in '" + category + "' ===");
        } else {
            items = this.plugin.getItemRegistry().getAllItems();
            this.sendMessage(sender, "\u00a76=== All Items (" + items.size() + ") ===");
        }
        int shown = Math.min(items.size(), 10);
        for (int i = 0; i < shown; ++i) {
            ItemInfo item = items.get(i);
            this.sendMessage(sender, "\u00a77- \u00a7f" + item.getName() + " \u00a78(" + item.getId() + ")");
        }
        if (items.size() > 10) {
            this.sendMessage(sender, "\u00a77... and " + (items.size() - 10) + " more. Use /jei to browse all.");
        }
    }

    private void handleReload(Object sender) {
        this.sendMessage(sender, "\u00a7eReloading item registry...");
        long start = System.currentTimeMillis();
        this.plugin.getItemRegistry().scanAllItems();
        long elapsed = System.currentTimeMillis() - start;
        int count = this.plugin.getItemRegistry().getItemCount();
        this.sendMessage(sender, "\u00a7aReload complete! Found " + count + " items in " + elapsed + "ms.");
    }

    private void showHelp(Object sender) {
        this.sendMessage(sender, "\u00a76=== HytaleJEI Commands ===");
        this.sendMessage(sender, "\u00a7e/jei \u00a77- Open the item browser");
        this.sendMessage(sender, "\u00a7e/jei search <query> \u00a77- Search for items");
        this.sendMessage(sender, "\u00a7e/jei info <item_id> \u00a77- Show item details");
        this.sendMessage(sender, "\u00a7e/jei list [category] \u00a77- List items");
        this.sendMessage(sender, "\u00a7e/jei reload \u00a77- Rescan registries");
        this.sendMessage(sender, "");
        this.sendMessage(sender, "\u00a76Search Tips:");
        this.sendMessage(sender, "\u00a77  @category \u00a7f- Filter by category (e.g., @tools)");
        this.sendMessage(sender, "\u00a77  #tag \u00a7f- Filter by tag (e.g., #ore)");
    }

    public List<String> tabComplete(Object sender, String[] args) {
        return List.of();
    }

    private void sendMessage(Object sender, String message) {
        System.out.println(this.stripColor(message));
    }

    private String stripColor(String message) {
        return message.replaceAll("\u00a7[0-9a-fk-or]", "");
    }
}

