/*
 * Decompiled with CFR 0.152.
 */
package dev.hytalemod.jei;

import dev.hytalemod.jei.command.JEICommand;
import dev.hytalemod.jei.registry.ItemRegistry;
import dev.hytalemod.jei.ui.JEIScreen;

public class HytaleJEIPlugin {
    private static HytaleJEIPlugin instance;
    private ItemRegistry itemRegistry;
    private JEIScreen jeiScreen;
    private JEICommand jeiCommand;

    public HytaleJEIPlugin() {
        instance = this;
        this.log("HytaleJEI loading...");
    }

    public void onEnable() {
        this.itemRegistry = new ItemRegistry();
        this.itemRegistry.scanAllItems();
        this.jeiScreen = new JEIScreen(this.itemRegistry);
        this.jeiCommand = new JEICommand(this);
        this.log("HytaleJEI enabled! Found " + this.itemRegistry.getItemCount() + " items.");
        this.log("Use /jei or press R to open the item browser.");
    }

    public void onDisable() {
        this.log("HytaleJEI disabled.");
    }

    public void openJEIScreen(Object player) {
        this.jeiScreen.open(player);
    }

    public void openJEIScreenWithSearch(Object player, String searchQuery) {
        this.jeiScreen.open(player, searchQuery);
    }

    public void onKeybindPressed(Object player) {
        this.openJEIScreen(player);
    }

    public ItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    public JEIScreen getJeiScreen() {
        return this.jeiScreen;
    }

    public JEICommand getJeiCommand() {
        return this.jeiCommand;
    }

    public static HytaleJEIPlugin getInstance() {
        return instance;
    }

    private void log(String message) {
        System.out.println("[HytaleJEI] " + message);
    }
}

