/*
 * Decompiled with CFR 0.152.
 */
package com.example.quadfurnace;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.command.system.CommandContext;
import com.hypixel.hytale.server.core.command.system.basecommands.AbstractPlayerCommand;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import javax.annotation.Nonnull;

public class FixFurnacesCommand
extends AbstractPlayerCommand {
    private static final String FURNACE_ID = "Bench_Furnace";
    private static final String DOUBLE_FURNACE_ID = "Bench_DoubleFurnace";

    public FixFurnacesCommand() {
        super("fixfurnaces", "Remove metadata from furnaces so they work in crafting recipes");
        this.setPermissionGroup(GameMode.Adventure);
    }

    protected void execute(@Nonnull CommandContext context, @Nonnull Store<EntityStore> store, @Nonnull Ref<EntityStore> ref, @Nonnull PlayerRef playerRef, @Nonnull World world) {
        Player player = (Player)store.getComponent(ref, Player.getComponentType());
        if (player == null) {
            context.sendMessage(Message.raw((String)"Could not get player!"));
            return;
        }
        Inventory inventory = player.getInventory();
        int fixedCount = 0;
        fixedCount += this.fixContainer(inventory.getHotbar());
        if ((fixedCount += this.fixContainer((ItemContainer)inventory.getCombinedBackpackStorageHotbar())) > 0) {
            context.sendMessage(Message.raw((String)("Fixed " + fixedCount + " furnace(s)! They can now be used for crafting.")));
        } else {
            context.sendMessage(Message.raw((String)"No furnaces with metadata found. Your furnaces are already good to go!"));
        }
    }

    private int fixContainer(ItemContainer container) {
        int fixed = 0;
        for (short i = 0; i < container.getCapacity(); i = (short)(i + 1)) {
            String itemId;
            ItemStack itemStack = container.getItemStack(i);
            if (itemStack == null || itemStack.isEmpty() || !FURNACE_ID.equals(itemId = itemStack.getItemId()) && !DOUBLE_FURNACE_ID.equals(itemId) || itemStack.getMetadata() == null) continue;
            ItemStack fixedStack = itemStack.withMetadata(null);
            container.setItemStackForSlot(i, fixedStack);
            ++fixed;
        }
        return fixed;
    }
}

