/*
 * Decompiled with CFR 0.152.
 */
package zurku.gravestones;

import com.hypixel.hytale.logger.HytaleLogger;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import zurku.gravestones.libs.gson.Gson;
import zurku.gravestones.libs.gson.GsonBuilder;
import zurku.gravestones.libs.gson.JsonObject;
import zurku.gravestones.libs.gson.JsonParser;

public class GravestoneSettings {
    private static final String SETTINGS_PATH = "plugins/Gravestones/settings.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final int CURRENT_VERSION = 2;
    private final int settingsVersion = 2;
    private boolean useVanillaModel = false;
    private transient HytaleLogger logger;

    public GravestoneSettings(HytaleLogger logger) {
        this.logger = logger;
    }

    public boolean isUseVanillaModel() {
        return this.useVanillaModel;
    }

    public void toggleVanillaTombstone() {
        this.useVanillaModel = !this.useVanillaModel;
        this.save();
    }

    public String getGravestoneBlockId() {
        return this.useVanillaModel ? "Furniture_Zurku_VanillaGravestone" : "Furniture_Zurku_Gravestone";
    }

    public void load() {
        File file = new File(SETTINGS_PATH);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonObject json = JsonParser.parseReader(reader).getAsJsonObject();
                int fileVersion = 1;
                if (json.has("settingsVersion")) {
                    fileVersion = json.get("settingsVersion").getAsInt();
                }
                if (fileVersion < 2) {
                    this.migrateSettings(json, fileVersion);
                }
                if (json.has("useVanillaModel")) {
                    this.useVanillaModel = json.get("useVanillaModel").getAsBoolean();
                }
                if (this.logger != null) {
                    if (fileVersion < 2) {
                        ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] Settings migrated from v" + fileVersion + " to v2");
                    } else {
                        ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] Settings loaded (v2)");
                    }
                }
                if (fileVersion < 2) {
                    this.save();
                }
            }
            catch (Exception e) {
                if (this.logger != null) {
                    ((HytaleLogger.Api)this.logger.atWarning()).log("[Gravestones] Failed to load settings, using defaults: " + e.getMessage());
                }
                this.useVanillaModel = false;
                try {
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.save();
            }
        } else {
            if (this.logger != null) {
                ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] Creating settings file");
            }
            this.save();
        }
    }

    private void migrateSettings(JsonObject json, int fromVersion) {
    }

    public void save() {
        block7: {
            File file = new File(SETTINGS_PATH);
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
            catch (IOException e) {
                if (this.logger == null) break block7;
                ((HytaleLogger.Api)this.logger.atWarning()).log("[Gravestones] Failed to save settings: " + e.getMessage());
            }
        }
    }
}

