/*
 * Decompiled with CFR 0.152.
 */
package zurku.gravestones;

import com.hypixel.hytale.assetstore.AssetRegistry;
import com.hypixel.hytale.component.ComponentRegistry;
import com.hypixel.hytale.component.ComponentRegistryProxy;
import com.hypixel.hytale.component.system.ISystem;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.command.system.AbstractCommand;
import com.hypixel.hytale.server.core.event.events.ecs.BreakBlockEvent;
import com.hypixel.hytale.server.core.event.events.player.PlayerConnectEvent;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathSystems;
import com.hypixel.hytale.server.core.modules.i18n.I18nModule;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.Interaction;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.RootInteraction;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nonnull;
import zurku.gravestones.CollectGravestoneInteraction;
import zurku.gravestones.DeathListenerSystem;
import zurku.gravestones.GravestoneCommand;
import zurku.gravestones.GravestoneManager;
import zurku.gravestones.GravestoneSettings;

public class GravestonePlugin
extends JavaPlugin {
    private GravestoneManager gravestoneManager;
    private GravestoneSettings settings;

    public GravestonePlugin(@Nonnull JavaPluginInit init) {
        super(init);
    }

    protected void setup() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Initializing...");
        this.cleanupOldVersionFiles();
        this.settings = new GravestoneSettings(this.getLogger());
        this.settings.load();
        this.gravestoneManager = new GravestoneManager(this, this.settings);
        this.registerInteraction();
        this.registerDeathListener();
        this.disableVanillaItemDrop();
        this.registerBreakListener();
        this.registerCommands();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Initialized");
    }

    protected void start() {
        this.registerConnectListener();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Ready");
    }

    protected void shutdown() {
        if (this.gravestoneManager != null) {
            this.gravestoneManager.shutdown();
        }
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Shutdown");
    }

    private void registerInteraction() {
        try {
            AssetRegistry.getAssetStore(Interaction.class).loadAssets(this.getName(), List.of(CollectGravestoneInteraction.INSTANCE));
            AssetRegistry.getAssetStore(RootInteraction.class).loadAssets(this.getName(), List.of(CollectGravestoneInteraction.ROOT));
            this.getCodecRegistry(Interaction.CODEC).register("CollectGravestone", CollectGravestoneInteraction.class, CollectGravestoneInteraction.CODEC);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[Gravestones] Interaction registration failed: " + e.getMessage());
        }
    }

    private void cleanupOldVersionFiles() {
        try {
            File cachedAssets;
            String userHome = System.getProperty("user.home");
            String[] possiblePaths = new String[]{userHome + "/AppData/Roaming/Hytale/UserData", userHome + "/.hytale/UserData", "UserData"};
            File userDataDir = null;
            for (String path : possiblePaths) {
                File dir = new File(path);
                if (!dir.exists() || !dir.isDirectory()) continue;
                userDataDir = dir;
                break;
            }
            if (userDataDir == null) {
                return;
            }
            File oldModsFolder = new File(userDataDir, "Mods/Zurku_Gravestones");
            if (oldModsFolder.exists() && oldModsFolder.isDirectory() && this.deleteDirectory(oldModsFolder)) {
                ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Removed old asset pack folder");
            }
            if ((cachedAssets = new File(userDataDir, "CachedAssets")).exists()) {
                this.cleanupGameplayConfigsRecursive(cachedAssets);
            }
            this.cleanupInDirectory(userDataDir);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[Gravestones] Cleanup error: " + e.getMessage());
        }
    }

    private void cleanupInDirectory(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            File gameplayConfigs;
            if (!file.isDirectory()) continue;
            if ((file.getName().equals("Zurku_Gravestones") || file.getName().contains("Gravestones")) && (gameplayConfigs = new File(file, "Server/GameplayConfigs")).exists() && gameplayConfigs.isDirectory() && this.deleteDirectory(gameplayConfigs)) {
                ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Removed old GameplayConfigs");
            }
            if (file.getName().equals("CachedAssets")) continue;
            this.cleanupInDirectory(file);
        }
    }

    private void cleanupGameplayConfigsRecursive(File dir) {
        File[] files;
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.getName().equals("GameplayConfigs")) {
            File gravestoneJson = new File(dir, "Gravestone.json");
            if (gravestoneJson.exists() && this.deleteDirectory(dir)) {
                ((HytaleLogger.Api)this.getLogger().atInfo()).log("[Gravestones] Removed old GameplayConfigs");
            }
            return;
        }
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this.cleanupGameplayConfigsRecursive(file);
            }
        }
    }

    private boolean deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        try {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file);
                        continue;
                    }
                    file.delete();
                }
            }
            return dir.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void disableVanillaItemDrop() {
        try {
            ComponentRegistryProxy proxy = this.getEntityStoreRegistry();
            Field field = proxy.getClass().getDeclaredField("registry");
            field.setAccessible(true);
            ((ComponentRegistry)field.get(proxy)).unregisterSystem(DeathSystems.DropPlayerDeathItems.class);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[Gravestones] Could not disable vanilla drops: " + e.getMessage());
        }
    }

    private void registerDeathListener() {
        try {
            this.getEntityStoreRegistry().registerSystem((ISystem)new DeathListenerSystem(this));
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.getLogger().atSevere()).log("[Gravestones] Death listener failed: " + e.getMessage());
        }
    }

    private void registerBreakListener() {
        try {
            this.getEventRegistry().registerGlobal(BreakBlockEvent.class, event -> {
                String id = event.getBlockType().getId();
                if (id != null && id.contains("Gravestone")) {
                    this.gravestoneManager.removeGravestoneAtPosition(event.getTargetBlock().getX(), event.getTargetBlock().getY(), event.getTargetBlock().getZ());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerConnectListener() {
        try {
            this.getEventRegistry().registerGlobal(PlayerConnectEvent.class, event -> {
                try {
                    I18nModule i18n = I18nModule.get();
                    if (i18n != null && event.getPlayer() != null) {
                        i18n.sendTranslations(event.getPlayer().getPlayerConnection(), "en-US");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerCommands() {
        try {
            this.getCommandRegistry().registerCommand((AbstractCommand)new GravestoneCommand(this.settings));
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("[Gravestones] Command registration failed: " + e.getMessage());
        }
    }

    public GravestoneManager getGravestoneManager() {
        return this.gravestoneManager;
    }
}

