/*
 * Decompiled with CFR 0.152.
 */
package zurku.gravestones;

import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.entity.UUIDComponent;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.SimpleItemContainer;
import com.hypixel.hytale.server.core.modules.entity.component.TransformComponent;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import zurku.gravestones.GravestoneData;
import zurku.gravestones.GravestonePlugin;
import zurku.gravestones.GravestoneSettings;

public class GravestoneManager {
    private static final int MAX_RETRIES = 10;
    private static final long RETRY_DELAY = 200L;
    private final GravestoneSettings settings;
    private final HytaleLogger logger;
    private final Map<UUID, List<GravestoneData>> playerGraves;
    private final Map<String, GravestoneData> locationIndex;
    private final ScheduledExecutorService executor;
    private Method getStateMethod;

    public GravestoneManager(GravestonePlugin plugin, GravestoneSettings settings) {
        this.settings = settings;
        this.logger = plugin.getLogger();
        this.playerGraves = new ConcurrentHashMap<UUID, List<GravestoneData>>();
        this.locationIndex = new ConcurrentHashMap<String, GravestoneData>();
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void removeGravestoneAtPosition(int x, int y, int z) {
        List<GravestoneData> list;
        GravestoneData data;
        String suffix = ":" + x + "," + y + "," + z;
        String key = null;
        for (String k : this.locationIndex.keySet()) {
            if (!k.endsWith(suffix)) continue;
            key = k;
            break;
        }
        if (key != null && (data = this.locationIndex.remove(key)) != null && (list = this.playerGraves.get(data.getPlayerId())) != null) {
            String finalKey = key;
            list.removeIf(g -> g.getLocationKey().equals(finalKey));
        }
    }

    public void onPlayerDeath(Player player, Store<EntityStore> store, Ref<EntityStore> ref, ItemStack[] items) {
        try {
            UUIDComponent uuidComp = (UUIDComponent)store.getComponent(ref, UUIDComponent.getComponentType());
            if (uuidComp == null) {
                return;
            }
            UUID playerId = uuidComp.getUuid();
            String playerName = player.getDisplayName();
            TransformComponent transform = (TransformComponent)store.getComponent(ref, TransformComponent.getComponentType());
            if (transform == null) {
                return;
            }
            Vector3d pos = transform.getPosition();
            int x = (int)pos.getX();
            int y = (int)pos.getY();
            int z = (int)pos.getZ();
            World world = player.getWorld();
            if (world == null) {
                return;
            }
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (items != null) {
                for (ItemStack item : items) {
                    if (item == null || item.isEmpty()) continue;
                    itemList.add(item);
                }
            }
            if (itemList.isEmpty()) {
                return;
            }
            GravestoneData data = new GravestoneData(playerId, x, y, z, world.getName());
            this.playerGraves.computeIfAbsent(playerId, k -> new ArrayList()).add(data);
            this.locationIndex.put(data.getLocationKey(), data);
            ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] Created for " + playerName + " at (" + x + ", " + y + ", " + z + ")");
            ArrayList finalItems = new ArrayList(itemList);
            this.executor.schedule(() -> world.execute(() -> this.placeGravestone(world, x, y, z, finalItems)), 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("[Gravestones] Death processing error: " + e.getMessage());
        }
    }

    private void placeGravestone(World world, int x, int y, int z, List<ItemStack> items) {
        try {
            long chunkKey = (long)(x >> 4) << 32 | (long)(z >> 4) & 0xFFFFFFFFL;
            WorldChunk chunk = world.getChunkIfLoaded(chunkKey);
            if (chunk == null) {
                world.getChunkAsync(chunkKey).thenAccept(c -> {
                    if (c != null) {
                        world.execute(() -> this.doPlacement(world, (WorldChunk)c, x, y, z, items));
                    }
                });
            } else {
                this.doPlacement(world, chunk, x, y, z, items);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("[Gravestones] Placement error: " + e.getMessage());
        }
    }

    private void doPlacement(World world, WorldChunk chunk, int x, int y, int z, List<ItemStack> items) {
        try {
            chunk.setBlock(x, y, z, 0);
            world.setBlock(x, y, z, this.settings.getGravestoneBlockId());
            this.executor.schedule(() -> world.execute(() -> this.fillContainer(world, x, y, z, items, 0)), 100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("[Gravestones] Block placement error: " + e.getMessage());
        }
    }

    private void fillContainer(World world, int x, int y, int z, List<ItemStack> items, int attempt) {
        try {
            BlockState state = this.getBlockState(world, x, y, z);
            if (state == null) {
                if (attempt < 10) {
                    ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] State null at (" + x + ", " + y + ", " + z + "), retry " + (attempt + 1) + "/10");
                    this.executor.schedule(() -> world.execute(() -> this.fillContainer(world, x, y, z, items, attempt + 1)), 200L, TimeUnit.MILLISECONDS);
                } else {
                    ((HytaleLogger.Api)this.logger.atWarning()).log("[Gravestones] Failed to get block state after 10 retries at (" + x + ", " + y + ", " + z + ")");
                }
                return;
            }
            if (state instanceof ItemContainerState) {
                ItemContainerState container = (ItemContainerState)state;
                SimpleItemContainer inv = new SimpleItemContainer((short)Math.max(items.size(), 1));
                container.setItemContainer(inv);
                inv.addItemStacks(items);
                ((HytaleLogger.Api)this.logger.atInfo()).log("[Gravestones] Filled container with " + items.size() + " items at (" + x + ", " + y + ", " + z + ")");
            } else {
                ((HytaleLogger.Api)this.logger.atWarning()).log("[Gravestones] Block state not ItemContainerState at (" + x + ", " + y + ", " + z + ") - type: " + state.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.atWarning()).log("[Gravestones] Container fill error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private BlockState getBlockState(World world, int x, int y, int z) {
        BlockState state = null;
        try {
            if (this.getStateMethod == null) {
                this.getStateMethod = world.getClass().getMethod("getState", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            if ((state = (BlockState)this.getStateMethod.invoke((Object)world, x, y, z, true)) != null) {
                return state;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            long key = (long)(x >> 4) << 32 | (long)(z >> 4) & 0xFFFFFFFFL;
            WorldChunk chunk = world.getChunkIfLoaded(key);
            if (chunk != null && (state = chunk.getState(x, y, z)) != null) {
                return state;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        try {
            Method getBlockStateMethod = world.getClass().getMethod("getBlockState", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            state = (BlockState)getBlockStateMethod.invoke((Object)world, x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }
}

