/*
 * Decompiled with CFR 0.152.
 */
package zurku.gravestones;

import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.math.util.MathUtil;
import com.hypixel.hytale.protocol.GameMode;
import com.hypixel.hytale.server.core.asset.type.gameplay.DeathConfig;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.CombinedItemContainer;
import com.hypixel.hytale.server.core.inventory.transaction.ItemStackSlotTransaction;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathComponent;
import com.hypixel.hytale.server.core.modules.entity.damage.DeathSystems;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import zurku.gravestones.GravestonePlugin;

public class DeathListenerSystem
extends DeathSystems.OnDeathSystem {
    private final GravestonePlugin plugin;
    private final HytaleLogger logger;

    public DeathListenerSystem(GravestonePlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public Query<EntityStore> getQuery() {
        return PlayerRef.getComponentType();
    }

    public void onComponentAdded(Ref<EntityStore> ref, DeathComponent death, Store<EntityStore> store, CommandBuffer<EntityStore> buffer) {
        try {
            Player player = (Player)store.getComponent(ref, Player.getComponentType());
            assert (player != null);
            if (player.getGameMode() == GameMode.Creative) {
                return;
            }
            death.setDisplayDataOnDeathScreen(true);
            World world = player.getWorld();
            if (world == null) {
                return;
            }
            DeathConfig config = world.getDeathConfig();
            if (config == null) {
                return;
            }
            DeathConfig.ItemsLossMode mode = config.getItemsLossMode();
            if (mode == DeathConfig.ItemsLossMode.NONE) {
                return;
            }
            Inventory inventory = player.getInventory();
            CombinedItemContainer combined = inventory.getCombinedEverything();
            double durLoss = config.getItemsDurabilityLossPercentage();
            if (durLoss > 0.0) {
                double ratio = durLoss / 100.0;
                boolean armorBroken = false;
                for (short i = 0; i < combined.getCapacity(); i = (short)(i + 1)) {
                    double loss;
                    ItemStack damaged;
                    ItemStackSlotTransaction tx;
                    ItemStack item = combined.getItemStack(i);
                    if (ItemStack.isEmpty((ItemStack)item) || item.isBroken() || !(tx = combined.replaceItemStackInSlot(i, item, damaged = item.withIncreasedDurability(-(loss = item.getMaxDurability() * ratio)))).getSlotAfter().isBroken() || item.getItem().getArmor() == null) continue;
                    armorBroken = true;
                }
                if (armorBroken) {
                    player.getStatModifiersManager().setRecalculate(true);
                }
            }
            List items = null;
            double lossPercent = config.getItemsAmountLossPercentage();
            switch (mode) {
                case ALL: {
                    items = inventory.dropAllItemStacks();
                    break;
                }
                case CONFIGURED: {
                    if (!(lossPercent > 0.0)) break;
                    double ratio = lossPercent / 100.0;
                    items = new ObjectArrayList();
                    for (short i = 0; i < combined.getCapacity(); i = (short)(i + 1)) {
                        ItemStack item = combined.getItemStack(i);
                        if (ItemStack.isEmpty((ItemStack)item) || !item.getItem().dropsOnDeath()) continue;
                        int take = Math.max(1, MathUtil.floor((double)((double)item.getQuantity() * ratio)));
                        items.add(item.withQuantity(take));
                        int keep = item.getQuantity() - take;
                        if (keep > 0) {
                            combined.replaceItemStackInSlot(i, item, item.withQuantity(keep));
                            continue;
                        }
                        combined.removeItemStackFromSlot(i);
                    }
                    break;
                }
            }
            if (items != null && !items.isEmpty()) {
                this.plugin.getGravestoneManager().onPlayerDeath(player, store, ref, items.toArray(new ItemStack[0]));
                death.setItemsLostOnDeath(items);
            }
        }
        catch (Exception e) {
            ((HytaleLogger.Api)this.logger.atSevere()).log("[Gravestones] Death processing error: " + e.getMessage());
        }
    }
}

