/*
 * Decompiled with CFR 0.152.
 */
package zurku.gravestones;

import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.hypixel.hytale.component.AddReason;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.ComponentAccessor;
import com.hypixel.hytale.component.Holder;
import com.hypixel.hytale.component.Ref;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.math.vector.Vector3i;
import com.hypixel.hytale.protocol.InteractionType;
import com.hypixel.hytale.server.core.entity.InteractionContext;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.inventory.container.CombinedItemContainer;
import com.hypixel.hytale.server.core.inventory.container.ItemContainer;
import com.hypixel.hytale.server.core.modules.entity.component.HeadRotation;
import com.hypixel.hytale.server.core.modules.entity.item.ItemComponent;
import com.hypixel.hytale.server.core.modules.interaction.interaction.CooldownHandler;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.RootInteraction;
import com.hypixel.hytale.server.core.modules.interaction.interaction.config.client.SimpleBlockInteraction;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.chunk.WorldChunk;
import com.hypixel.hytale.server.core.universe.world.meta.BlockState;
import com.hypixel.hytale.server.core.universe.world.meta.state.ItemContainerState;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import java.lang.reflect.Method;
import java.util.List;

public class CollectGravestoneInteraction
extends SimpleBlockInteraction {
    private static Method getStateMethod;
    public static final BuilderCodec<CollectGravestoneInteraction> CODEC;
    public static final CollectGravestoneInteraction INSTANCE;
    public static final RootInteraction ROOT;

    public CollectGravestoneInteraction() {
    }

    public CollectGravestoneInteraction(String id) {
        super(id);
    }

    protected void interactWithBlock(World world, CommandBuffer<EntityStore> buffer, InteractionType type, InteractionContext ctx, ItemStack held, Vector3i pos, CooldownHandler cooldown) {
        Ref ref = ctx.getEntity();
        Store store = ref.getStore();
        Player player = (Player)buffer.getComponent(ref, Player.getComponentType());
        if (player == null) {
            return;
        }
        BlockState state = CollectGravestoneInteraction.getBlockState(world, pos.x, pos.y, pos.z);
        if (!(state instanceof ItemContainerState)) {
            return;
        }
        ItemContainerState containerState = (ItemContainerState)state;
        if (!containerState.isAllowViewing() || !containerState.canOpen(ref, buffer)) {
            return;
        }
        CombinedItemContainer playerInv = player.getInventory().getCombinedEverything();
        ItemContainer graveInv = containerState.getItemContainer();
        for (short i = 0; i < graveInv.getCapacity(); i = (short)(i + 1)) {
            ItemStack item = graveInv.getItemStack(i);
            if (item == null || item.isEmpty()) continue;
            ItemStack remainder = playerInv.addItemStack(item).getRemainder();
            graveInv.setItemStackForSlot(i, remainder);
        }
        if (!graveInv.isEmpty()) {
            world.execute(() -> {
                Holder[] drops;
                HeadRotation rot = (HeadRotation)store.getComponent(ref, HeadRotation.getComponentType());
                Vector3f facing = rot != null ? rot.getRotation() : new Vector3f();
                List remaining = graveInv.dropAllItemStacks();
                Vector3d dropPos = pos.clone().add(0, 1, 0).toVector3d();
                for (Holder drop : drops = ItemComponent.generateItemDrops((ComponentAccessor)store, (List)remaining, (Vector3d)dropPos, (Vector3f)facing)) {
                    world.getEntityStore().getStore().addEntity(drop, AddReason.SPAWN);
                }
            });
        }
        world.execute(() -> world.breakBlock(pos.x, pos.y, pos.z, 0));
    }

    protected void simulateInteractWithBlock(InteractionType type, InteractionContext ctx, ItemStack held, World world, Vector3i pos) {
    }

    private static BlockState getBlockState(World world, int x, int y, int z) {
        BlockState state = null;
        try {
            if (getStateMethod == null) {
                getStateMethod = world.getClass().getMethod("getState", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            if ((state = (BlockState)getStateMethod.invoke((Object)world, x, y, z, true)) != null) {
                return state;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            long key = (long)(x >> 4) << 32 | (long)(z >> 4) & 0xFFFFFFFFL;
            WorldChunk chunk = world.getChunkIfLoaded(key);
            if (chunk != null && (state = chunk.getState(x, y, z)) != null) {
                return state;
            }
        }
        catch (Exception key) {
            // empty catch block
        }
        try {
            Method getBlockStateMethod = world.getClass().getMethod("getBlockState", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            state = (BlockState)getBlockStateMethod.invoke((Object)world, x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    static {
        CODEC = BuilderCodec.builder(CollectGravestoneInteraction.class, CollectGravestoneInteraction::new, (BuilderCodec)SimpleBlockInteraction.CODEC).build();
        INSTANCE = new CollectGravestoneInteraction("Collect_Gravestone");
        ROOT = new RootInteraction(INSTANCE.getId(), new String[]{INSTANCE.getId()});
    }
}

