/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.util;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1Encodable;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.DEROctetString;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.Attribute;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.x500.X500Name;
import com.easywebmap.shaded.bouncycastle.asn1.x509.Extension;
import com.easywebmap.shaded.bouncycastle.asn1.x509.Extensions;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralName;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralNames;
import com.easywebmap.shaded.bouncycastle.cert.CertIOException;
import com.easywebmap.shaded.bouncycastle.cert.X509CertificateHolder;
import com.easywebmap.shaded.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import com.easywebmap.shaded.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import com.easywebmap.shaded.bouncycastle.openssl.PEMParser;
import com.easywebmap.shaded.bouncycastle.operator.ContentSigner;
import com.easywebmap.shaded.bouncycastle.operator.OperatorCreationException;
import com.easywebmap.shaded.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCS10CertificationRequest;
import com.easywebmap.shaded.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import org.shredzone.acme4j.Identifier;

public final class CertificateUtils {
    public static final ASN1ObjectIdentifier ACME_VALIDATION = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.31").intern();

    private CertificateUtils() {
    }

    public static PKCS10CertificationRequest readCSR(InputStream in) throws IOException {
        try (PEMParser pemParser = new PEMParser(new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object parsedObj = pemParser.readObject();
            if (!(parsedObj instanceof PKCS10CertificationRequest)) {
                throw new IOException("Not a PKCS10 CSR");
            }
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)parsedObj;
            return pKCS10CertificationRequest;
        }
    }

    public static X509Certificate createTlsAlpn01Certificate(KeyPair keypair, Identifier id, byte[] acmeValidation) throws IOException {
        Objects.requireNonNull(keypair, "keypair");
        Objects.requireNonNull(id, "id");
        if (acmeValidation == null || acmeValidation.length != 32) {
            throw new IllegalArgumentException("Bad acmeValidation parameter");
        }
        long now = System.currentTimeMillis();
        X500Name issuer = new X500Name("CN=acme.invalid");
        BigInteger serial = BigInteger.valueOf(now);
        Instant notBefore = Instant.ofEpochMilli(now);
        Instant notAfter = notBefore.plus(Duration.ofDays(7L));
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(notBefore), Date.from(notAfter), issuer, keypair.getPublic());
        GeneralName[] gns = new GeneralName[1];
        switch (id.getType()) {
            case "dns": {
                gns[0] = new GeneralName(2, id.getDomain());
                break;
            }
            case "ip": {
                gns[0] = new GeneralName(7, id.getIP().getHostAddress());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Identifier type " + id.getType());
            }
        }
        certBuilder.addExtension(Extension.subjectAlternativeName, false, new GeneralNames(gns));
        certBuilder.addExtension(ACME_VALIDATION, true, new DEROctetString(acmeValidation));
        return CertificateUtils.buildCertificate(certBuilder::build, keypair.getPrivate());
    }

    public static X509Certificate createTestRootCertificate(String subject, Instant notBefore, Instant notAfter, KeyPair keypair) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(keypair, "keypair");
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(new X500Name(subject), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), new X500Name(subject), keypair.getPublic());
        return CertificateUtils.buildCertificate(certBuilder::build, keypair.getPrivate());
    }

    public static X509Certificate createTestIntermediateCertificate(String subject, Instant notBefore, Instant notAfter, PublicKey intermediatePublicKey, X509Certificate issuer, PrivateKey issuerPrivateKey) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(intermediatePublicKey, "intermediatePublicKey");
        Objects.requireNonNull(issuer, "issuer");
        Objects.requireNonNull(issuerPrivateKey, "issuerPrivateKey");
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(new X500Name(issuer.getIssuerX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), new X500Name(subject), intermediatePublicKey);
        return CertificateUtils.buildCertificate(certBuilder::build, issuerPrivateKey);
    }

    public static X509Certificate createTestCertificate(PKCS10CertificationRequest csr, Instant notBefore, Instant notAfter, X509Certificate issuer, PrivateKey issuerPrivateKey) {
        Objects.requireNonNull(csr, "csr");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(issuer, "issuer");
        Objects.requireNonNull(issuerPrivateKey, "issuerPrivateKey");
        try {
            ASN1Encodable[] extensions;
            JcaPKCS10CertificationRequest jcaCsr = new JcaPKCS10CertificationRequest(csr);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(new X500Name(issuer.getIssuerX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), csr.getSubject(), jcaCsr.getPublicKey());
            Attribute[] attr = csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            if (attr.length > 0 && (extensions = attr[0].getAttrValues().toArray()).length > 0 && extensions[0] instanceof Extensions) {
                GeneralNames san = GeneralNames.fromExtensions((Extensions)extensions[0], Extension.subjectAlternativeName);
                boolean critical = csr.getSubject().getRDNs().length == 0;
                certBuilder.addExtension(Extension.subjectAlternativeName, critical, san);
            }
            return CertificateUtils.buildCertificate(certBuilder::build, issuerPrivateKey);
        }
        catch (CertIOException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Invalid CSR", ex);
        }
    }

    private static X509Certificate buildCertificate(Function<ContentSigner, X509CertificateHolder> builder, PrivateKey privateKey) {
        try {
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
            byte[] cert = builder.apply(signerBuilder.build(privateKey)).getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert));
        }
        catch (OperatorCreationException | IOException | CertificateException ex) {
            throw new IllegalArgumentException("Could not build certificate", ex);
        }
    }
}

