/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.toolbox;

import com.easywebmap.shaded.jose4j.json.JsonUtil;
import com.easywebmap.shaded.jose4j.lang.JoseException;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.exception.AcmeProtocolException;
import org.shredzone.acme4j.toolbox.AcmeUtils;

public final class JSON
implements Serializable {
    private static final long serialVersionUID = 418332625174149030L;
    private static final JSON EMPTY_JSON = new JSON(new HashMap<String, Object>());
    private final String path;
    private final Map<String, Object> data;

    private JSON(Map<String, Object> data) {
        this("", data);
    }

    private JSON(String path, Map<String, Object> data) {
        this.path = path;
        this.data = data;
    }

    public static JSON parse(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String json = reader.lines().map(String::trim).collect(Collectors.joining());
            JSON jSON = JSON.parse(json);
            return jSON;
        }
    }

    public static JSON parse(String json) {
        try {
            return new JSON(JsonUtil.parseJson(json));
        }
        catch (JoseException ex) {
            throw new AcmeProtocolException("Bad JSON: " + json, ex);
        }
    }

    public static JSON fromMap(Map<String, Object> data) {
        return JSON.parse(JsonUtil.toJson(data));
    }

    public static JSON empty() {
        return EMPTY_JSON;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public Value get(String key) {
        return new Value((String)(this.path.isEmpty() ? key : this.path + "." + key), this.data.get(key));
    }

    public Value getFeature(String key) {
        return new Value((String)(this.path.isEmpty() ? key : this.path + "." + key), this.data.get(key)).onFeature(key);
    }

    public String toString() {
        return JsonUtil.toJson(this.data);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.data);
    }

    public static final class Value {
        private final String path;
        @Nullable
        private final Object val;

        private Value(String path, @Nullable Object val) {
            this.path = path;
            this.val = val;
        }

        public boolean isPresent() {
            return this.val != null;
        }

        public Optional<Value> optional() {
            return this.val != null ? Optional.of(this) : Optional.empty();
        }

        public Value onFeature(String feature) {
            if (this.val == null) {
                throw new AcmeNotSupportedException(feature);
            }
            return this;
        }

        public <T> Optional<T> map(Function<Value, T> mapper) {
            return this.optional().map(mapper);
        }

        public String asString() {
            return this.required().toString();
        }

        public JSON asObject() {
            return new JSON(this.path, this.required(Map.class));
        }

        public JSON asEncodedObject() {
            try {
                byte[] raw = AcmeUtils.base64UrlDecode(this.asString());
                return new JSON(this.path, JsonUtil.parseJson(new String(raw, StandardCharsets.UTF_8)));
            }
            catch (JoseException | IllegalArgumentException ex) {
                throw new AcmeProtocolException(this.path + ": expected an encoded object", ex);
            }
        }

        public Problem asProblem(URL baseUrl) {
            return new Problem(this.asObject(), baseUrl);
        }

        public Identifier asIdentifier() {
            return new Identifier(this.asObject());
        }

        public Array asArray() {
            if (this.val == null) {
                return new Array(this.path, Collections.emptyList());
            }
            try {
                return new Array(this.path, (List)this.val);
            }
            catch (ClassCastException ex) {
                throw new AcmeProtocolException(this.path + ": expected an array", ex);
            }
        }

        public int asInt() {
            return this.required(Number.class).intValue();
        }

        public boolean asBoolean() {
            return this.required(Boolean.class);
        }

        public URI asURI() {
            try {
                return new URI(this.asString());
            }
            catch (URISyntaxException ex) {
                throw new AcmeProtocolException(this.path + ": bad URI " + this.val, ex);
            }
        }

        public URL asURL() {
            try {
                return new URL(this.asString());
            }
            catch (MalformedURLException ex) {
                throw new AcmeProtocolException(this.path + ": bad URL " + this.val, ex);
            }
        }

        public Instant asInstant() {
            try {
                return AcmeUtils.parseTimestamp(this.asString());
            }
            catch (IllegalArgumentException ex) {
                throw new AcmeProtocolException(this.path + ": bad date " + this.val, ex);
            }
        }

        public Duration asDuration() {
            return Duration.ofSeconds(this.required(Number.class).longValue());
        }

        public byte[] asBinary() {
            return AcmeUtils.base64UrlDecode(this.asString());
        }

        public Status asStatus() {
            return Status.parse(this.asString());
        }

        private Object required() {
            if (this.val == null) {
                throw new AcmeProtocolException(this.path + ": required, but not set");
            }
            return this.val;
        }

        private <T> T required(Class<T> type) {
            if (this.val == null) {
                throw new AcmeProtocolException(this.path + ": required, but not set");
            }
            if (!type.isInstance(this.val)) {
                throw new AcmeProtocolException(this.path + ": cannot convert to " + type.getSimpleName());
            }
            return type.cast(this.val);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            return Objects.equals(this.val, ((Value)obj).val);
        }

        public int hashCode() {
            return this.val != null ? this.val.hashCode() : 0;
        }
    }

    private static class ValueIterator
    implements Iterator<Value> {
        private final Array array;
        private int index = 0;

        public ValueIterator(Array array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.size();
        }

        @Override
        public Value next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Array
    implements Iterable<Value> {
        private final String path;
        private final List<Object> data;

        private Array(String path, List<Object> data) {
            this.path = path;
            this.data = data;
        }

        public int size() {
            return this.data.size();
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Value get(int index) {
            return new Value(this.path + "[" + index + "]", this.data.get(index));
        }

        public Stream<Value> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public Iterator<Value> iterator() {
            return new ValueIterator(this);
        }
    }
}

