/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.web.handlers;

import com.easywebmap.EasyWebMap;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TileHandler {
    private static final Pattern TILE_PATTERN = Pattern.compile("/api/tiles/([^/]+)/(-?\\d+)/(-?\\d+)/(-?\\d+)\\.png");
    private final EasyWebMap plugin;

    public TileHandler(EasyWebMap plugin) {
        this.plugin = plugin;
    }

    public void handle(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.method() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        Matcher matcher = TILE_PATTERN.matcher(req.uri());
        if (!matcher.matches()) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String worldName = matcher.group(1);
        int zoom = Integer.parseInt(matcher.group(2));
        int x = Integer.parseInt(matcher.group(3));
        int z = Integer.parseInt(matcher.group(4));
        if (!this.plugin.getConfig().isWorldEnabled(worldName)) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        this.plugin.getTileManager().getTile(worldName, zoom, x, z).thenAccept(data -> {
            if (!ctx.channel().isActive()) {
                return;
            }
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])data));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"image/png").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)((byte[])data).length).set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"max-age=300").set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
            if (keepAlive) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
                ctx.writeAndFlush((Object)response);
            } else {
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        });
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

