/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.web.handlers;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class StaticHandler {
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();

    public void handle(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.method() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String uri = req.uri();
        int queryIndex = uri.indexOf(63);
        if (queryIndex >= 0) {
            uri = uri.substring(0, queryIndex);
        }
        if (uri.equals("/") || uri.isEmpty()) {
            uri = "/index.html";
        }
        if (uri.contains("..")) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        String resourcePath = "/web" + uri;
        byte[] content = this.loadResource(resourcePath);
        if (content == null) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        String contentType = this.getContentType(uri);
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        String cacheControl = uri.endsWith(".html") || uri.equals("/") ? "no-cache" : "max-age=86400, immutable";
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])content));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.length).set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)cacheControl);
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
            ctx.writeAndFlush((Object)response);
        } else {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadResource(String path) {
        try (InputStream is = this.getClass().getResourceAsStream(path);){
            int bytesRead;
            if (is == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = is.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getContentType(String path) {
        String ext;
        String mimeType;
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex >= 0 && (mimeType = MIME_TYPES.get(ext = path.substring(dotIndex).toLowerCase())) != null) {
            return mimeType;
        }
        return "application/octet-stream";
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    static {
        MIME_TYPES.put(".html", "text/html");
        MIME_TYPES.put(".css", "text/css");
        MIME_TYPES.put(".js", "application/javascript");
        MIME_TYPES.put(".png", "image/png");
        MIME_TYPES.put(".jpg", "image/jpeg");
        MIME_TYPES.put(".jpeg", "image/jpeg");
        MIME_TYPES.put(".gif", "image/gif");
        MIME_TYPES.put(".svg", "image/svg+xml");
        MIME_TYPES.put(".ico", "image/x-icon");
        MIME_TYPES.put(".json", "application/json");
    }
}

