/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.web.handlers;

import com.easywebmap.EasyWebMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlayerHandler {
    private static final Pattern PLAYERS_PATTERN = Pattern.compile("/api/players/([^/]+)");
    private static final Gson GSON = new GsonBuilder().create();
    private final EasyWebMap plugin;

    public PlayerHandler(EasyWebMap plugin) {
        this.plugin = plugin;
    }

    public void handlePlayers(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.method() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        Matcher matcher = PLAYERS_PATTERN.matcher(req.uri());
        if (!matcher.matches()) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String worldName = matcher.group(1);
        if (!this.plugin.getConfig().isWorldEnabled(worldName)) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        World world = Universe.get().getWorld(worldName);
        if (world == null) {
            this.sendJson(ctx, new ArrayList());
            return;
        }
        List<Map<String, Object>> players = this.getPlayersInWorld(world);
        this.sendJson(ctx, players);
    }

    public void handleWorlds(ChannelHandlerContext ctx, FullHttpRequest req) {
        if (req.method() != HttpMethod.GET) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        ArrayList worlds = new ArrayList();
        for (World world : Universe.get().getWorlds().values()) {
            if (!this.plugin.getConfig().isWorldEnabled(world.getName())) continue;
            HashMap<String, String> worldInfo = new HashMap<String, String>();
            worldInfo.put("name", world.getName());
            worlds.add(worldInfo);
        }
        this.sendJson(ctx, worlds);
    }

    private List<Map<String, Object>> getPlayersInWorld(World world) {
        ArrayList<Map<String, Object>> players = new ArrayList<Map<String, Object>>();
        for (PlayerRef playerRef : world.getPlayerRefs()) {
            try {
                Transform transform = playerRef.getTransform();
                if (transform == null) continue;
                Vector3d pos = transform.getPosition();
                Vector3f rot = transform.getRotation();
                HashMap<String, Object> playerData = new HashMap<String, Object>();
                playerData.put("name", playerRef.getUsername());
                playerData.put("uuid", playerRef.getUuid().toString());
                playerData.put("x", pos.x);
                playerData.put("y", pos.y);
                playerData.put("z", pos.z);
                playerData.put("yaw", Float.valueOf(rot != null ? rot.y : 0.0f));
                players.add(playerData);
            }
            catch (Exception exception) {}
        }
        return players;
    }

    private void sendJson(ChannelHandlerContext ctx, Object data) {
        String json = GSON.toJson(data);
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])bytes));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length).set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

