/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.web.handlers;

import com.easywebmap.EasyWebMap;
import com.easywebmap.map.TileManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class BatchTileHandler {
    private static final Gson GSON = new Gson();
    private static final int MAX_BATCH_SIZE = 200;
    private final EasyWebMap plugin;
    private final TileManager tileManager;

    public BatchTileHandler(EasyWebMap plugin, TileManager tileManager) {
        this.plugin = plugin;
        this.tileManager = tileManager;
    }

    public void handle(ChannelHandlerContext ctx, FullHttpRequest req) {
        JsonObject requestJson;
        if (req.method() != HttpMethod.POST) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String body = req.content().toString(StandardCharsets.UTF_8);
        try {
            requestJson = JsonParser.parseString((String)body).getAsJsonObject();
        }
        catch (Exception e) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (!requestJson.has("world") || !requestJson.has("tiles")) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String worldName = requestJson.get("world").getAsString();
        if (!this.plugin.getConfig().isWorldEnabled(worldName)) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        JsonArray tilesArray = requestJson.getAsJsonArray("tiles");
        if (tilesArray.size() > 200) {
            this.sendError(ctx, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            return;
        }
        ArrayList<TileCoord> coords = new ArrayList<TileCoord>();
        for (int i = 0; i < tilesArray.size(); ++i) {
            JsonObject tile = tilesArray.get(i).getAsJsonObject();
            int z = tile.get("z").getAsInt();
            int x = tile.get("x").getAsInt();
            int y = tile.get("y").getAsInt();
            coords.add(new TileCoord(z, x, y));
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        LinkedHashMap<CallSite, CompletableFuture<byte[]>> futures = new LinkedHashMap<CallSite, CompletableFuture<byte[]>>();
        for (TileCoord coord : coords) {
            String key = coord.z + "/" + coord.x + "/" + coord.y;
            CompletableFuture<byte[]> future = this.tileManager.getTile(worldName, coord.z, coord.x, coord.y);
            futures.put((CallSite)((Object)key), future);
        }
        CompletableFuture.allOf(futures.values().toArray(new CompletableFuture[0])).thenAccept(v -> {
            if (!ctx.channel().isActive()) {
                return;
            }
            JsonObject response = new JsonObject();
            JsonObject tilesObj = new JsonObject();
            for (Map.Entry entry : futures.entrySet()) {
                byte[] data = (byte[])((CompletableFuture)entry.getValue()).join();
                JsonObject tileObj = new JsonObject();
                if (this.isEmptyTile(data)) {
                    tileObj.addProperty("empty", Boolean.valueOf(true));
                } else {
                    tileObj.addProperty("data", Base64.getEncoder().encodeToString(data));
                }
                tilesObj.add((String)entry.getKey(), (JsonElement)tileObj);
            }
            response.add("tiles", (JsonElement)tilesObj);
            response.addProperty("timestamp", (Number)System.currentTimeMillis());
            String json = GSON.toJson((JsonElement)response);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])bytes));
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json").set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length).set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*").set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)"POST, OPTIONS").set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)"Content-Type");
            if (keepAlive) {
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"keep-alive");
                ctx.writeAndFlush((Object)httpResponse);
            } else {
                ctx.writeAndFlush((Object)httpResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        });
    }

    private boolean isEmptyTile(byte[] data) {
        return data == null || data.length < 500;
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static class TileCoord {
        final int z;
        final int x;
        final int y;

        TileCoord(int z, int x, int y) {
            this.z = z;
            this.x = x;
            this.y = y;
        }
    }
}

