/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.web;

import com.easywebmap.EasyWebMap;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;

public class WebSocketHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final EasyWebMap plugin;
    private final WebSocketServerHandshaker handshaker;

    public WebSocketHandler(EasyWebMap plugin, WebSocketServerHandshaker handshaker) {
        this.plugin = plugin;
        this.handshaker = handshaker;
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content().retain()));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.plugin.getPlayerTracker().removeChannel(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

