/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.tracker;

import com.easywebmap.EasyWebMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PlayerTracker {
    private static final Gson GSON = new GsonBuilder().create();
    private final EasyWebMap plugin;
    private final Set<Channel> connectedChannels;
    private ScheduledExecutorService scheduler;

    public PlayerTracker(EasyWebMap plugin) {
        this.plugin = plugin;
        this.connectedChannels = ConcurrentHashMap.newKeySet();
    }

    public void start() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "easywebmap-tracker");
            t.setDaemon(true);
            return t;
        });
        int intervalMs = this.plugin.getConfig().getUpdateIntervalMs();
        this.scheduler.scheduleAtFixedRate(this::broadcastPlayerPositions, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (Channel channel : this.connectedChannels) {
            channel.close();
        }
        this.connectedChannels.clear();
    }

    public void addChannel(Channel channel) {
        this.connectedChannels.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.connectedChannels.remove(channel);
    }

    public int getConnectionCount() {
        return this.connectedChannels.size();
    }

    private void broadcastPlayerPositions() {
        if (this.connectedChannels.isEmpty()) {
            return;
        }
        HashMap<String, List<Map<String, Object>>> worldPlayers = new HashMap<String, List<Map<String, Object>>>();
        for (World world : Universe.get().getWorlds().values()) {
            List<Map<String, Object>> players;
            if (!this.plugin.getConfig().isWorldEnabled(world.getName()) || (players = this.getPlayersInWorld(world)).isEmpty()) continue;
            worldPlayers.put(world.getName(), players);
        }
        if (worldPlayers.isEmpty()) {
            return;
        }
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "players");
        message.put("timestamp", System.currentTimeMillis());
        message.put("worlds", worldPlayers);
        String json = GSON.toJson(message);
        TextWebSocketFrame frame = new TextWebSocketFrame(json);
        for (Channel channel : this.connectedChannels) {
            if (!channel.isActive()) continue;
            channel.writeAndFlush((Object)frame.retainedDuplicate());
        }
        frame.release();
    }

    private List<Map<String, Object>> getPlayersInWorld(World world) {
        ArrayList<Map<String, Object>> players = new ArrayList<Map<String, Object>>();
        for (PlayerRef playerRef : world.getPlayerRefs()) {
            try {
                Transform transform = playerRef.getTransform();
                if (transform == null) continue;
                Vector3d pos = transform.getPosition();
                Vector3f rot = transform.getRotation();
                HashMap<String, Object> playerData = new HashMap<String, Object>();
                playerData.put("name", playerRef.getUsername());
                playerData.put("uuid", playerRef.getUuid().toString());
                playerData.put("x", pos.x);
                playerData.put("y", pos.y);
                playerData.put("z", pos.z);
                playerData.put("yaw", Float.valueOf(rot != null ? rot.y : 0.0f));
                players.add(playerData);
            }
            catch (Exception exception) {}
        }
        return players;
    }
}

