/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.ssl;

import com.easywebmap.EasyWebMap;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.shredzone.acme4j.Account;
import org.shredzone.acme4j.AccountBuilder;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Order;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.challenge.Http01Challenge;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.util.KeyPairUtils;

public class AcmeManager {
    private static final String PRODUCTION_URL = "acme://letsencrypt.org";
    private static final String STAGING_URL = "acme://letsencrypt.org/staging";
    private static final int KEY_SIZE = 2048;
    private static final Duration RENEWAL_THRESHOLD = Duration.ofDays(30L);
    private final EasyWebMap plugin;
    private final Path sslDir;
    private final Path accountKeyFile;
    private final Path domainKeyFile;
    private final Path domainCertFile;
    private final ConcurrentHashMap<String, String> pendingChallenges = new ConcurrentHashMap();
    private final AtomicReference<SslContext> currentSslContext = new AtomicReference();
    private final AtomicReference<Instant> certExpiry = new AtomicReference();
    private ScheduledExecutorService renewalScheduler;
    private volatile boolean initialized = false;

    public AcmeManager(EasyWebMap plugin) {
        this.plugin = plugin;
        this.sslDir = plugin.getDataDirectory().resolve("ssl");
        this.accountKeyFile = this.sslDir.resolve("account.key");
        this.domainKeyFile = this.sslDir.resolve("domain.key");
        this.domainCertFile = this.sslDir.resolve("domain.crt");
    }

    public CompletableFuture<Boolean> initialize() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.createDirectories(this.sslDir, new FileAttribute[0]);
                if (Files.exists(this.domainCertFile, new LinkOption[0]) && Files.exists(this.domainKeyFile, new LinkOption[0]) && this.loadExistingCertificate()) {
                    if (!this.shouldRenew()) {
                        System.out.println("[EasyWebMap] Loaded existing SSL certificate");
                        this.initialized = true;
                        return true;
                    }
                    System.out.println("[EasyWebMap] Certificate needs renewal");
                }
                return this.obtainCertificate();
            }
            catch (Exception e) {
                System.err.println("[EasyWebMap] SSL initialization failed: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        });
    }

    private boolean loadExistingCertificate() {
        try {
            SslContext ctx = SslContextBuilder.forServer((File)this.domainCertFile.toFile(), (File)this.domainKeyFile.toFile()).build();
            this.currentSslContext.set(ctx);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (InputStream is = Files.newInputStream(this.domainCertFile, new OpenOption[0]);){
                X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
                this.certExpiry.set(cert.getNotAfter().toInstant());
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("[EasyWebMap] Failed to load existing certificate: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean obtainCertificate() {
        String domain = this.plugin.getConfig().getDomain();
        if (domain == null || domain.isBlank()) {
            System.err.println("[EasyWebMap] HTTPS enabled but no domain configured");
            return false;
        }
        System.out.println("[EasyWebMap] Requesting SSL certificate for " + domain);
        try {
            Session session;
            KeyPair accountKeyPair = this.loadOrCreateKeyPair(this.accountKeyFile);
            KeyPair domainKeyPair = this.loadOrCreateKeyPair(this.domainKeyFile);
            String acmeUrl = this.plugin.getConfig().isProductionAcme() ? PRODUCTION_URL : STAGING_URL;
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(AcmeManager.class.getClassLoader());
            try {
                session = new Session(acmeUrl);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            Account account = this.findOrRegisterAccount(session, accountKeyPair);
            System.out.println("[EasyWebMap] ACME account ready");
            Order order = account.newOrder().domains(domain).create();
            System.out.println("[EasyWebMap] Certificate order created");
            for (Authorization auth : order.getAuthorizations()) {
                if (auth.getStatus() == Status.VALID) continue;
                this.processAuthorization(auth);
            }
            order.execute(domainKeyPair);
            int attempts = 0;
            while (order.getStatus() != Status.VALID && attempts++ < 30) {
                if (order.getStatus() == Status.INVALID) {
                    throw new AcmeException("Order failed: " + String.valueOf(order.getError().orElse(null)));
                }
                Thread.sleep(3000L);
                order.update();
            }
            if (order.getStatus() != Status.VALID) {
                throw new AcmeException("Order did not complete in time");
            }
            Certificate certificate = order.getCertificate();
            try (FileWriter fw = new FileWriter(this.domainCertFile.toFile());){
                certificate.writeCertificate(fw);
            }
            System.out.println("[EasyWebMap] Certificate obtained successfully!");
            this.pendingChallenges.clear();
            return this.loadExistingCertificate();
        }
        catch (Exception e) {
            System.err.println("[EasyWebMap] Failed to obtain certificate: " + e.getMessage());
            e.printStackTrace();
            this.pendingChallenges.clear();
            return false;
        }
    }

    private KeyPair loadOrCreateKeyPair(Path keyFile) throws IOException {
        if (Files.exists(keyFile, new LinkOption[0])) {
            try (FileReader fr = new FileReader(keyFile.toFile());){
                KeyPair keyPair = KeyPairUtils.readKeyPair(fr);
                return keyPair;
            }
        }
        KeyPair keyPair = KeyPairUtils.createKeyPair(2048);
        try (FileWriter fw = new FileWriter(keyFile.toFile());){
            KeyPairUtils.writeKeyPair(keyPair, fw);
        }
        return keyPair;
    }

    private Account findOrRegisterAccount(Session session, KeyPair accountKeyPair) throws AcmeException {
        AccountBuilder accountBuilder = new AccountBuilder().agreeToTermsOfService().useKeyPair(accountKeyPair);
        String email = this.plugin.getConfig().getAcmeEmail();
        if (email != null && !email.isBlank()) {
            accountBuilder.addEmail(email);
        }
        return accountBuilder.create(session);
    }

    private void processAuthorization(Authorization auth) throws AcmeException, InterruptedException {
        Http01Challenge challenge = auth.findChallenge(Http01Challenge.class).orElseThrow(() -> new AcmeException("No HTTP-01 challenge available"));
        String token = challenge.getToken();
        String content = challenge.getAuthorization();
        this.pendingChallenges.put(token, content);
        System.out.println("[EasyWebMap] HTTP-01 challenge ready for token: " + token);
        challenge.trigger();
        int attempts = 0;
        while (auth.getStatus() != Status.VALID && attempts++ < 30) {
            if (auth.getStatus() == Status.INVALID) {
                this.pendingChallenges.remove(token);
                throw new AcmeException("Challenge failed: " + String.valueOf(challenge.getError().orElse(null)));
            }
            Thread.sleep(3000L);
            auth.update();
        }
        this.pendingChallenges.remove(token);
        if (auth.getStatus() != Status.VALID) {
            throw new AcmeException("Authorization did not complete in time");
        }
        System.out.println("[EasyWebMap] Domain validated successfully");
    }

    public String getChallengeResponse(String token) {
        return this.pendingChallenges.get(token);
    }

    public boolean hasPendingChallenge() {
        return !this.pendingChallenges.isEmpty();
    }

    public SslContext getSslContext() {
        return this.currentSslContext.get();
    }

    public boolean isInitialized() {
        return this.initialized && this.currentSslContext.get() != null;
    }

    public Instant getCertificateExpiry() {
        return this.certExpiry.get();
    }

    public boolean shouldRenew() {
        Instant expiry = this.certExpiry.get();
        if (expiry == null) {
            return true;
        }
        return Instant.now().plus(RENEWAL_THRESHOLD).isAfter(expiry);
    }

    public void startRenewalScheduler() {
        if (this.renewalScheduler != null) {
            return;
        }
        this.renewalScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "EasyWebMap-SSL-Renewal");
            t.setDaemon(true);
            return t;
        });
        this.renewalScheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.shouldRenew()) {
                    System.out.println("[EasyWebMap] Certificate renewal triggered");
                    if (this.obtainCertificate()) {
                        System.out.println("[EasyWebMap] Certificate renewed successfully");
                        this.plugin.getWebServer().reloadSslContext(this.currentSslContext.get());
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[EasyWebMap] Certificate renewal failed: " + e.getMessage());
            }
        }, 24L, 24L, TimeUnit.HOURS);
    }

    public CompletableFuture<Boolean> renewNow() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.obtainCertificate()) {
                this.plugin.getWebServer().reloadSslContext(this.currentSslContext.get());
                return true;
            }
            return false;
        });
    }

    public void shutdown() {
        if (this.renewalScheduler != null) {
            this.renewalScheduler.shutdownNow();
            this.renewalScheduler = null;
        }
    }
}

