/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.jose4j.keys.resolvers;

import com.easywebmap.shaded.jose4j.jwk.PublicJsonWebKey;
import com.easywebmap.shaded.jose4j.jws.JsonWebSignature;
import com.easywebmap.shaded.jose4j.jwx.JsonWebStructure;
import com.easywebmap.shaded.jose4j.keys.resolvers.VerificationKeyResolver;
import com.easywebmap.shaded.jose4j.lang.JoseException;
import com.easywebmap.shaded.jose4j.lang.UnresolvableKeyException;
import java.security.Key;
import java.util.List;

public class EmbeddedJwkVerificationKeyResolver
implements VerificationKeyResolver {
    private PublicJsonWebKey jwk;

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        try {
            this.jwk = jws.getJwkHeader();
        }
        catch (JoseException e) {
            throw new UnresolvableKeyException("Problem processing jwk from JWS header (" + e.getMessage() + ")", e);
        }
        if (this.jwk == null) {
            throw new UnresolvableKeyException("No jwk in JWS header");
        }
        return this.jwk.getKey();
    }

    public PublicJsonWebKey getJwk() {
        return this.jwk;
    }
}

