/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.jose4j.jwk;

import com.easywebmap.shaded.jose4j.jwk.EllipticCurveJsonWebKey;
import com.easywebmap.shaded.jose4j.jwk.PublicJsonWebKey;
import com.easywebmap.shaded.jose4j.keys.EcKeyUtil;
import com.easywebmap.shaded.jose4j.lang.JoseException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;

public class EcJwkGenerator {
    public static EllipticCurveJsonWebKey generateJwk(ECParameterSpec spec) throws JoseException {
        return EcJwkGenerator.generateJwk(spec, null, null);
    }

    public static EllipticCurveJsonWebKey generateJwk(ECParameterSpec spec, String provider, SecureRandom secureRandom) throws JoseException {
        EcKeyUtil keyUtil = new EcKeyUtil(provider, secureRandom);
        KeyPair keyPair = keyUtil.generateKeyPair(spec);
        PublicKey publicKey = keyPair.getPublic();
        EllipticCurveJsonWebKey ecJwk = (EllipticCurveJsonWebKey)PublicJsonWebKey.Factory.newPublicJwk(publicKey);
        ecJwk.setPrivateKey(keyPair.getPrivate());
        return ecJwk;
    }
}

