/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.jose4j.jwe;

import com.easywebmap.shaded.jose4j.jca.ProviderContext;
import com.easywebmap.shaded.jose4j.jwa.CryptoPrimitive;
import com.easywebmap.shaded.jose4j.jwe.CipherUtil;
import com.easywebmap.shaded.jose4j.jwe.ContentEncryptionAlgorithm;
import com.easywebmap.shaded.jose4j.jwe.ContentEncryptionKeyDescriptor;
import com.easywebmap.shaded.jose4j.jwe.ContentEncryptionKeys;
import com.easywebmap.shaded.jose4j.jwe.JsonWebEncryption;
import com.easywebmap.shaded.jose4j.jwe.KeyManagementAlgorithm;
import com.easywebmap.shaded.jose4j.jwe.WrappingKeyManagementAlgorithm;
import com.easywebmap.shaded.jose4j.jwk.JsonWebKey;
import com.easywebmap.shaded.jose4j.jwx.Headers;
import com.easywebmap.shaded.jose4j.jwx.KeyValidationSupport;
import com.easywebmap.shaded.jose4j.keys.KeyPersuasion;
import com.easywebmap.shaded.jose4j.lang.ByteUtil;
import com.easywebmap.shaded.jose4j.lang.ExceptionHelp;
import com.easywebmap.shaded.jose4j.lang.InvalidKeyException;
import com.easywebmap.shaded.jose4j.lang.JoseException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.crypto.spec.SecretKeySpec;

public class RsaKeyManagementAlgorithm
extends WrappingKeyManagementAlgorithm
implements KeyManagementAlgorithm {
    public RsaKeyManagementAlgorithm(String javaAlg, String alg) {
        super(javaAlg, alg);
        this.setKeyType("RSA");
        this.setKeyPersuasion(KeyPersuasion.ASYMMETRIC);
    }

    @Override
    public void validateEncryptionKey(Key managementKey, ContentEncryptionAlgorithm contentEncryptionAlg) throws InvalidKeyException {
        PublicKey pk = KeyValidationSupport.castKey(managementKey, PublicKey.class);
        KeyValidationSupport.checkRsaKeySize(pk);
    }

    @Override
    public void validateDecryptionKey(Key managementKey, ContentEncryptionAlgorithm contentEncryptionAlg) throws InvalidKeyException {
        PrivateKey pk = KeyValidationSupport.castKey(managementKey, PrivateKey.class);
        KeyValidationSupport.checkRsaKeySize(pk);
    }

    @Override
    public boolean isAvailable() {
        try {
            return CipherUtil.getCipher(this.getJavaAlgorithm(), null) != null;
        }
        catch (JoseException e) {
            return false;
        }
    }

    public static class Rsa1_5
    extends RsaKeyManagementAlgorithm
    implements KeyManagementAlgorithm {
        public Rsa1_5() {
            super("RSA/ECB/PKCS1Padding", "RSA1_5");
        }

        @Override
        public Key manageForDecrypt(CryptoPrimitive cryptoPrimitive, byte[] encryptedKey, ContentEncryptionKeyDescriptor cekDesc, Headers headers, ProviderContext providerContext) throws JoseException {
            Key unwrappedKey;
            String cekAlg = cekDesc.getContentEncryptionKeyAlgorithm();
            int expectedKeySize = cekDesc.getContentEncryptionKeyByteLength();
            SecretKeySpec randomKey = new SecretKeySpec(ByteUtil.randomBytes(expectedKeySize), cekAlg);
            try {
                unwrappedKey = this.unwrap(cryptoPrimitive, encryptedKey, providerContext, cekDesc);
                if (unwrappedKey.getEncoded().length != expectedKeySize) {
                    unwrappedKey = randomKey;
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    String flatStack = ExceptionHelp.toStringWithCausesAndAbbreviatedStack(e, JsonWebEncryption.class);
                    this.log.debug("Key unwrap/decrypt failed. Substituting a randomly generated CEK and proceeding. {}", (Object)flatStack);
                }
                unwrappedKey = randomKey;
            }
            return unwrappedKey;
        }
    }

    public static class RsaOaep256
    extends RsaKeyManagementAlgorithm
    implements KeyManagementAlgorithm {
        public RsaOaep256() {
            super("RSA/ECB/OAEPWithSHA-256AndMGF1Padding", "RSA-OAEP-256");
            this.setAlgorithmParameterSpec(new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
        }

        @Override
        public boolean isAvailable() {
            try {
                JsonWebKey jwk = JsonWebKey.Factory.newJwk("{\"kty\":\"RSA\",\"n\":\"sXchDaQebHnPiGvyDOAT4saGEUetSyo9MKLOoWFsueri23bOdgWp4Dy1WlUzewbgBHod5pcM9H95GQRV3JDXboIRROSBigeC5yjU1hGzHHyXss8UDprecbAYxknTcQkhslANGRUZmdTOQ5qTRsLAt6BTYuyvVRdhS8exSZEy_c4gs_7svlJJQ4H9_NxsiIoLwAEk7-Q3UXERGYw_75IDrGA84-lA_-Ct4eTlXHBIY2EaV7t7LjJaynVJCpkv4LKjTTAumiGUIuQhrNhZLuF_RJLqHpM2kgWFLU7-VTdL1VbC2tejvcI2BlMkEpk1BzBZI0KQB0GaDWFLN-aEAw3vRw\",\"e\":\"AQAB\"}");
                ContentEncryptionKeyDescriptor cekDesc = new ContentEncryptionKeyDescriptor(16, "AES");
                ContentEncryptionKeys contentEncryptionKeys = this.manageForEncrypt(jwk.getKey(), cekDesc, null, null, new ProviderContext());
                return contentEncryptionKeys != null;
            }
            catch (JoseException e) {
                this.log.debug(this.getAlgorithmIdentifier() + " is not available due to " + ExceptionHelp.toStringWithCauses(e));
                return false;
            }
        }
    }

    public static class RsaOaep
    extends RsaKeyManagementAlgorithm
    implements KeyManagementAlgorithm {
        public RsaOaep() {
            super("RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "RSA-OAEP");
        }
    }
}

