/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.jcajce.provider.ntruprime;

import com.easywebmap.shaded.bouncycastle.crypto.SecretWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.jcajce.spec.KEMExtractSpec;
import com.easywebmap.shaded.bouncycastle.jcajce.spec.KEMGenerateSpec;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import com.easywebmap.shaded.bouncycastle.pqc.jcajce.provider.ntruprime.BCSNTRUPrimePrivateKey;
import com.easywebmap.shaded.bouncycastle.pqc.jcajce.provider.ntruprime.BCSNTRUPrimePublicKey;
import com.easywebmap.shaded.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.DestroyFailedException;

public class SNTRUPrimeKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KEMGenerateSpec genSpec;
    private SecureRandom random;
    private KEMExtractSpec extSpec;

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof KEMGenerateSpec) {
            this.genSpec = (KEMGenerateSpec)algorithmParameterSpec;
            this.extSpec = null;
        } else if (algorithmParameterSpec instanceof KEMExtractSpec) {
            this.genSpec = null;
            this.extSpec = (KEMExtractSpec)algorithmParameterSpec;
        } else {
            throw new InvalidAlgorithmParameterException("unknown spec");
        }
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (this.genSpec != null) {
            BCSNTRUPrimePublicKey bCSNTRUPrimePublicKey = (BCSNTRUPrimePublicKey)this.genSpec.getPublicKey();
            SNTRUPrimeKEMGenerator sNTRUPrimeKEMGenerator = new SNTRUPrimeKEMGenerator(this.random);
            SecretWithEncapsulation secretWithEncapsulation = sNTRUPrimeKEMGenerator.generateEncapsulated(bCSNTRUPrimePublicKey.getKeyParams());
            SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(secretWithEncapsulation.getSecret(), this.genSpec.getKeyAlgorithmName()), secretWithEncapsulation.getEncapsulation());
            try {
                secretWithEncapsulation.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new IllegalStateException("key cleanup failed");
            }
            return secretKeyWithEncapsulation;
        }
        BCSNTRUPrimePrivateKey bCSNTRUPrimePrivateKey = (BCSNTRUPrimePrivateKey)this.extSpec.getPrivateKey();
        SNTRUPrimeKEMExtractor sNTRUPrimeKEMExtractor = new SNTRUPrimeKEMExtractor(bCSNTRUPrimePrivateKey.getKeyParams());
        byte[] byArray = this.extSpec.getEncapsulation();
        byte[] byArray2 = sNTRUPrimeKEMExtractor.extractSecret(byArray);
        SecretKeyWithEncapsulation secretKeyWithEncapsulation = new SecretKeyWithEncapsulation(new SecretKeySpec(byArray2, this.extSpec.getKeyAlgorithmName()), byArray);
        Arrays.clear(byArray2);
        return secretKeyWithEncapsulation;
    }
}

