/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.jcajce.provider.ntruprime;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1Set;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import com.easywebmap.shaded.bouncycastle.pqc.jcajce.interfaces.SNTRUPrimeKey;
import com.easywebmap.shaded.bouncycastle.pqc.jcajce.spec.SNTRUPrimeParameterSpec;
import com.easywebmap.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSNTRUPrimePrivateKey
implements PrivateKey,
SNTRUPrimeKey {
    private static final long serialVersionUID = 1L;
    private transient SNTRUPrimePrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSNTRUPrimePrivateKey(SNTRUPrimePrivateKeyParameters sNTRUPrimePrivateKeyParameters) {
        this.params = sNTRUPrimePrivateKeyParameters;
    }

    public BCSNTRUPrimePrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SNTRUPrimePrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSNTRUPrimePrivateKey) {
            BCSNTRUPrimePrivateKey bCSNTRUPrimePrivateKey = (BCSNTRUPrimePrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSNTRUPrimePrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "NTRULPRime";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SNTRUPrimeParameterSpec getParameterSpec() {
        return SNTRUPrimeParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    SNTRUPrimePrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

