/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.crypto.util;

import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.easywebmap.shaded.bouncycastle.crypto.EncapsulatedSecretExtractor;
import com.easywebmap.shaded.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.SecretWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.crypto.util.DEROtherInfo;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.KEMParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMExtractor;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUKEMExtractor;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUKEMGenerator;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import java.io.IOException;
import java.security.SecureRandom;

public class PQCOtherInfoGenerator {
    protected final DEROtherInfo.Builder otherInfoBuilder;
    protected final SecureRandom random;
    protected boolean used = false;

    public PQCOtherInfoGenerator(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        this.otherInfoBuilder = new DEROtherInfo.Builder(algorithmIdentifier, byArray, byArray2);
        this.random = secureRandom;
    }

    private static byte[] getEncoded(AsymmetricKeyParameter asymmetricKeyParameter) {
        try {
            return SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(asymmetricKeyParameter).getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static AsymmetricKeyParameter getPublicKey(byte[] byArray) throws IOException {
        return PublicKeyFactory.createKey(byArray);
    }

    public static class PartyU
    extends PQCOtherInfoGenerator {
        private AsymmetricCipherKeyPair aKp;
        private EncapsulatedSecretExtractor encSE;

        public PartyU(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            if (kEMParameters instanceof KyberParameters) {
                KyberKeyPairGenerator kyberKeyPairGenerator = new KyberKeyPairGenerator();
                kyberKeyPairGenerator.init(new KyberKeyGenerationParameters(secureRandom, (KyberParameters)kEMParameters));
                this.aKp = kyberKeyPairGenerator.generateKeyPair();
                this.encSE = new KyberKEMExtractor((KyberPrivateKeyParameters)this.aKp.getPrivate());
            } else if (kEMParameters instanceof NTRUParameters) {
                NTRUKeyPairGenerator nTRUKeyPairGenerator = new NTRUKeyPairGenerator();
                nTRUKeyPairGenerator.init(new NTRUKeyGenerationParameters(secureRandom, (NTRUParameters)kEMParameters));
                this.aKp = nTRUKeyPairGenerator.generateKeyPair();
                this.encSE = new NTRUKEMExtractor((NTRUPrivateKeyParameters)this.aKp.getPrivate());
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartA() {
            return PQCOtherInfoGenerator.getEncoded(this.aKp.getPublic());
        }

        public DEROtherInfo generate(byte[] byArray) {
            this.otherInfoBuilder.withSuppPrivInfo(this.encSE.extractSecret(byArray));
            return this.otherInfoBuilder.build();
        }
    }

    public static class PartyV
    extends PQCOtherInfoGenerator {
        private EncapsulatedSecretGenerator encSG;

        public PartyV(KEMParameters kEMParameters, AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
            super(algorithmIdentifier, byArray, byArray2, secureRandom);
            if (kEMParameters instanceof KyberParameters) {
                this.encSG = new KyberKEMGenerator(secureRandom);
            } else if (kEMParameters instanceof NTRUParameters) {
                this.encSG = new NTRUKEMGenerator(secureRandom);
            } else {
                throw new IllegalArgumentException("unknown KEMParameters");
            }
        }

        public PQCOtherInfoGenerator withSuppPubInfo(byte[] byArray) {
            this.otherInfoBuilder.withSuppPubInfo(byArray);
            return this;
        }

        public byte[] getSuppPrivInfoPartB(byte[] byArray) {
            this.used = false;
            try {
                SecretWithEncapsulation secretWithEncapsulation = this.encSG.generateEncapsulated(PQCOtherInfoGenerator.getPublicKey(byArray));
                this.otherInfoBuilder.withSuppPrivInfo(secretWithEncapsulation.getSecret());
                return secretWithEncapsulation.getEncapsulation();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("cannot decode public key");
            }
        }

        public DEROtherInfo generate() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return this.otherInfoBuilder.build();
        }
    }
}

