/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.crypto.saber;

import com.easywebmap.shaded.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.SecretWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.saber.SABEREngine;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class SABERKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SABERKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        SABERPublicKeyParameters sABERPublicKeyParameters = (SABERPublicKeyParameters)asymmetricKeyParameter;
        SABEREngine sABEREngine = sABERPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[sABEREngine.getCipherTextSize()];
        byte[] byArray2 = new byte[sABEREngine.getSessionKeySize()];
        sABEREngine.crypto_kem_enc(byArray, byArray2, sABERPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

