/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.crypto.frodo;

import com.easywebmap.shaded.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.SecretWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.frodo.FrodoPublicKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class FrodoKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public FrodoKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        FrodoPublicKeyParameters frodoPublicKeyParameters = (FrodoPublicKeyParameters)asymmetricKeyParameter;
        FrodoEngine frodoEngine = frodoPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[frodoEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[frodoEngine.getSessionKeySize()];
        frodoEngine.kem_enc(byArray, byArray2, frodoPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

