/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pqc.crypto.cmce;

import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.KeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.cmce.CMCEKeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import java.security.SecureRandom;

public class CMCEKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private CMCEKeyGenerationParameters cmceParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.cmceParams = (CMCEKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        CMCEEngine cMCEEngine = this.cmceParams.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[cMCEEngine.getPublicKeySize()];
        cMCEEngine.kem_keypair(byArray2, byArray, this.random);
        CMCEPublicKeyParameters cMCEPublicKeyParameters = new CMCEPublicKeyParameters(this.cmceParams.getParameters(), byArray2);
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = new CMCEPrivateKeyParameters(this.cmceParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(cMCEPublicKeyParameters, cMCEPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

