/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pkix;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1Sequence;
import com.easywebmap.shaded.bouncycastle.asn1.x500.X500Name;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralName;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralSubtree;
import com.easywebmap.shaded.bouncycastle.asn1.x509.NameConstraintValidatorException;
import com.easywebmap.shaded.bouncycastle.pkix.ASN1PKIXNameConstraintValidator;
import com.easywebmap.shaded.bouncycastle.pkix.PKIXNameConstraintValidatorException;

public class PKIXNameConstraintValidator {
    ASN1PKIXNameConstraintValidator validator = new ASN1PKIXNameConstraintValidator();

    public int hashCode() {
        return this.validator.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PKIXNameConstraintValidator)) {
            return false;
        }
        PKIXNameConstraintValidator pKIXNameConstraintValidator = (PKIXNameConstraintValidator)object;
        return this.validator.equals(pKIXNameConstraintValidator.validator);
    }

    public void checkPermittedDN(ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        try {
            this.validator.checkPermittedDN(X500Name.getInstance(aSN1Sequence));
        }
        catch (NameConstraintValidatorException nameConstraintValidatorException) {
            throw new PKIXNameConstraintValidatorException(nameConstraintValidatorException.getMessage(), nameConstraintValidatorException);
        }
    }

    public void checkExcludedDN(ASN1Sequence aSN1Sequence) throws PKIXNameConstraintValidatorException {
        try {
            this.validator.checkExcludedDN(X500Name.getInstance(aSN1Sequence));
        }
        catch (NameConstraintValidatorException nameConstraintValidatorException) {
            throw new PKIXNameConstraintValidatorException(nameConstraintValidatorException.getMessage(), nameConstraintValidatorException);
        }
    }

    public void checkPermitted(GeneralName generalName) throws PKIXNameConstraintValidatorException {
        try {
            this.validator.checkPermitted(generalName);
        }
        catch (NameConstraintValidatorException nameConstraintValidatorException) {
            throw new PKIXNameConstraintValidatorException(nameConstraintValidatorException.getMessage(), nameConstraintValidatorException);
        }
    }

    public void checkExcluded(GeneralName generalName) throws PKIXNameConstraintValidatorException {
        try {
            this.validator.checkExcluded(generalName);
        }
        catch (NameConstraintValidatorException nameConstraintValidatorException) {
            throw new PKIXNameConstraintValidatorException(nameConstraintValidatorException.getMessage(), nameConstraintValidatorException);
        }
    }

    public void intersectPermittedSubtree(GeneralSubtree generalSubtree) {
        this.validator.intersectPermittedSubtree(generalSubtree);
    }

    public void intersectPermittedSubtree(GeneralSubtree[] generalSubtreeArray) {
        this.validator.intersectPermittedSubtree(generalSubtreeArray);
    }

    public void intersectEmptyPermittedSubtree(int n) {
        this.validator.intersectEmptyPermittedSubtree(n);
    }

    public void addExcludedSubtree(GeneralSubtree generalSubtree) {
        this.validator.addExcludedSubtree(generalSubtree);
    }

    public String toString() {
        return this.validator.toString();
    }
}

