/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pkcs.bc;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.BlockCipher;
import com.easywebmap.shaded.bouncycastle.crypto.BufferedBlockCipher;
import com.easywebmap.shaded.bouncycastle.crypto.CipherParameters;
import com.easywebmap.shaded.bouncycastle.crypto.ExtendedDigest;
import com.easywebmap.shaded.bouncycastle.crypto.digests.SHA1Digest;
import com.easywebmap.shaded.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.io.CipherOutputStream;
import com.easywebmap.shaded.bouncycastle.crypto.paddings.PKCS7Padding;
import com.easywebmap.shaded.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.easywebmap.shaded.bouncycastle.operator.GenericKey;
import com.easywebmap.shaded.bouncycastle.operator.OutputEncryptor;
import com.easywebmap.shaded.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.OutputStream;
import java.security.SecureRandom;

public class BcPKCS12PBEOutputEncryptorBuilder {
    private ExtendedDigest digest;
    private BufferedBlockCipher engine;
    private ASN1ObjectIdentifier algorithm;
    private SecureRandom random;
    private int iterationCount = 1024;

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, BlockCipher blockCipher) {
        this(aSN1ObjectIdentifier, blockCipher, new SHA1Digest());
    }

    public BcPKCS12PBEOutputEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, BlockCipher blockCipher, ExtendedDigest extendedDigest) {
        this.algorithm = aSN1ObjectIdentifier;
        this.engine = new PaddedBufferedBlockCipher(blockCipher, new PKCS7Padding());
        this.digest = extendedDigest;
    }

    public BcPKCS12PBEOutputEncryptorBuilder setIterationCount(int n) {
        this.iterationCount = n;
        return this;
    }

    public OutputEncryptor build(final char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] byArray = new byte[20];
        this.random.nextBytes(byArray);
        final PKCS12PBEParams pKCS12PBEParams = new PKCS12PBEParams(byArray, this.iterationCount);
        CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(this.algorithm, this.digest, this.engine.getBlockSize(), pKCS12PBEParams, cArray);
        this.engine.init(true, cipherParameters);
        return new OutputEncryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pKCS12PBEParams);
            }

            @Override
            public OutputStream getOutputStream(OutputStream outputStream) {
                return new CipherOutputStream(outputStream, BcPKCS12PBEOutputEncryptorBuilder.this.engine);
            }

            @Override
            public GenericKey getKey() {
                return new GenericKey(new AlgorithmIdentifier(BcPKCS12PBEOutputEncryptorBuilder.this.algorithm, pKCS12PBEParams), PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
            }
        };
    }
}

