/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pkcs.bc;

import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.CipherParameters;
import com.easywebmap.shaded.bouncycastle.crypto.ExtendedDigest;
import com.easywebmap.shaded.bouncycastle.crypto.digests.SHA1Digest;
import com.easywebmap.shaded.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.io.CipherInputStream;
import com.easywebmap.shaded.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import com.easywebmap.shaded.bouncycastle.operator.GenericKey;
import com.easywebmap.shaded.bouncycastle.operator.InputDecryptor;
import com.easywebmap.shaded.bouncycastle.operator.InputDecryptorProvider;
import com.easywebmap.shaded.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest extendedDigest) {
        this.digest = extendedDigest;
    }

    public InputDecryptorProvider build(final char[] cArray) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher paddedBufferedBlockCipher = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters cipherParameters = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, paddedBufferedBlockCipher.getBlockSize(), pKCS12PBEParams, cArray);
                paddedBufferedBlockCipher.init(false, cipherParameters);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream inputStream) {
                        return new CipherInputStream(inputStream, paddedBufferedBlockCipher);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(algorithmIdentifier, PKCS12ParametersGenerator.PKCS12PasswordToBytes(cArray));
                    }
                };
            }
        };
    }
}

