/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.pkcs;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Sequence;
import com.easywebmap.shaded.bouncycastle.asn1.DEROctetString;
import com.easywebmap.shaded.bouncycastle.asn1.DERSequence;
import com.easywebmap.shaded.bouncycastle.asn1.DLSequence;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.ContentInfo;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.MacData;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.Pfx;
import com.easywebmap.shaded.bouncycastle.cms.CMSEncryptedDataGenerator;
import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.CMSProcessableByteArray;
import com.easywebmap.shaded.bouncycastle.operator.OutputEncryptor;
import com.easywebmap.shaded.bouncycastle.pkcs.MacDataGenerator;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCS12PfxPdu;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCS12SafeBag;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCSException;
import com.easywebmap.shaded.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag pKCS12SafeBag) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(pKCS12SafeBag.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag pKCS12SafeBag) throws IOException {
        return this.addEncryptedData(outputEncryptor, new DERSequence(pKCS12SafeBag.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag[] pKCS12SafeBagArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i != pKCS12SafeBagArray.length; ++i) {
            aSN1EncodableVector.add(pKCS12SafeBagArray[i].toASN1Structure());
        }
        return this.addEncryptedData(outputEncryptor, new DLSequence(aSN1EncodableVector));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, ASN1Sequence aSN1Sequence) throws IOException {
        CMSEncryptedDataGenerator cMSEncryptedDataGenerator = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(cMSEncryptedDataGenerator.generate(new CMSProcessableByteArray(aSN1Sequence.getEncoded()), outputEncryptor).toASN1Structure());
        }
        catch (CMSException cMSException) {
            throw new PKCSIOException(cMSException.getMessage(), cMSException.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder, char[] cArray) throws PKCSException {
        Object object;
        byte[] byArray;
        AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            byArray = authenticatedSafe.getEncoded();
        }
        catch (IOException iOException) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + iOException.getMessage(), iOException);
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(byArray));
        MacData macData = null;
        if (pKCS12MacCalculatorBuilder != null) {
            object = new MacDataGenerator(pKCS12MacCalculatorBuilder);
            macData = ((MacDataGenerator)object).build(cArray, byArray);
        }
        object = new Pfx(contentInfo, macData);
        return new PKCS12PfxPdu((Pfx)object);
    }
}

