/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.operator.jcajce;

import com.easywebmap.shaded.bouncycastle.asn1.cms.GenericHybridParameters;
import com.easywebmap.shaded.bouncycastle.asn1.cms.RsaKemParameters;
import com.easywebmap.shaded.bouncycastle.asn1.iso.ISOIECObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.crypto.util.DEROtherInfo;
import com.easywebmap.shaded.bouncycastle.jcajce.spec.KTSParameterSpec;
import com.easywebmap.shaded.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.easywebmap.shaded.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.easywebmap.shaded.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.easywebmap.shaded.bouncycastle.operator.AsymmetricKeyWrapper;
import com.easywebmap.shaded.bouncycastle.operator.GenericKey;
import com.easywebmap.shaded.bouncycastle.operator.OperatorException;
import com.easywebmap.shaded.bouncycastle.operator.jcajce.JceSymmetricKeyWrapper;
import com.easywebmap.shaded.bouncycastle.operator.jcajce.OperatorHelper;
import com.easywebmap.shaded.bouncycastle.operator.jcajce.OperatorUtils;
import com.easywebmap.shaded.bouncycastle.util.Arrays;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.crypto.Cipher;

public class JceKTSKeyWrapper
extends AsymmetricKeyWrapper {
    private final String symmetricWrappingAlg;
    private final int keySizeInBits;
    private final byte[] partyUInfo;
    private final byte[] partyVInfo;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PublicKey publicKey;
    private SecureRandom random;

    public JceKTSKeyWrapper(PublicKey publicKey, String string, int n, byte[] byArray, byte[] byArray2) {
        super(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_rsa_KEM, new GenericHybridParameters(new AlgorithmIdentifier(ISOIECObjectIdentifiers.id_kem_rsa, new RsaKemParameters(new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)), (n + 7) / 8)), JceSymmetricKeyWrapper.determineKeyEncAlg(string, n))));
        this.publicKey = publicKey;
        this.symmetricWrappingAlg = string;
        this.keySizeInBits = n;
        this.partyUInfo = Arrays.clone(byArray);
        this.partyVInfo = Arrays.clone(byArray2);
    }

    public JceKTSKeyWrapper(X509Certificate x509Certificate, String string, int n, byte[] byArray, byte[] byArray2) {
        this(x509Certificate.getPublicKey(), string, n, byArray, byArray2);
    }

    public JceKTSKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKTSKeyWrapper setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JceKTSKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        Cipher cipher = this.helper.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm(), new HashMap());
        try {
            DEROtherInfo dEROtherInfo = new DEROtherInfo.Builder(JceSymmetricKeyWrapper.determineKeyEncAlg(this.symmetricWrappingAlg, this.keySizeInBits), this.partyUInfo, this.partyVInfo).build();
            KTSParameterSpec kTSParameterSpec = new KTSParameterSpec.Builder(this.symmetricWrappingAlg, this.keySizeInBits, dEROtherInfo.getEncoded()).build();
            cipher.init(3, (Key)this.publicKey, kTSParameterSpec, this.random);
            return cipher.wrap(OperatorUtils.getJceKey(genericKey));
        }
        catch (Exception exception) {
            throw new OperatorException("Unable to wrap contents key: " + exception.getMessage(), exception);
        }
    }
}

