/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.operator.bc;

import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.easywebmap.shaded.bouncycastle.crypto.ExtendedDigest;
import com.easywebmap.shaded.bouncycastle.crypto.Signer;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.crypto.signers.RSADigestSigner;
import com.easywebmap.shaded.bouncycastle.crypto.util.PublicKeyFactory;
import com.easywebmap.shaded.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import com.easywebmap.shaded.bouncycastle.operator.OperatorCreationException;
import com.easywebmap.shaded.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

