/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.operator.bc;

import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.Digest;
import com.easywebmap.shaded.bouncycastle.crypto.ExtendedDigest;
import com.easywebmap.shaded.bouncycastle.operator.DigestCalculator;
import com.easywebmap.shaded.bouncycastle.operator.DigestCalculatorProvider;
import com.easywebmap.shaded.bouncycastle.operator.OperatorCreationException;
import com.easywebmap.shaded.bouncycastle.operator.bc.BcDefaultDigestProvider;
import com.easywebmap.shaded.bouncycastle.operator.bc.BcDigestProvider;
import java.io.IOException;
import java.io.OutputStream;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private BcDigestProvider digestProvider = BcDefaultDigestProvider.INSTANCE;

    @Override
    public DigestCalculator get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier);
        final DigestOutputStream digestOutputStream = new DigestOutputStream(extendedDigest);
        return new DigestCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            @Override
            public OutputStream getOutputStream() {
                return digestOutputStream;
            }

            @Override
            public byte[] getDigest() {
                return digestOutputStream.getDigest();
            }
        };
    }

    private static class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest) {
            this.dig = digest;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        @Override
        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

