/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.operator.bc;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricBlockCipher;
import com.easywebmap.shaded.bouncycastle.crypto.CipherParameters;
import com.easywebmap.shaded.bouncycastle.crypto.InvalidCipherTextException;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.crypto.params.ParametersWithRandom;
import com.easywebmap.shaded.bouncycastle.operator.AsymmetricKeyWrapper;
import com.easywebmap.shaded.bouncycastle.operator.GenericKey;
import com.easywebmap.shaded.bouncycastle.operator.OperatorException;
import com.easywebmap.shaded.bouncycastle.operator.bc.OperatorUtils;
import java.security.SecureRandom;

public abstract class BcAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private AsymmetricKeyParameter publicKey;
    private SecureRandom random;

    public BcAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier);
        this.publicKey = asymmetricKeyParameter;
    }

    public BcAsymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        AsymmetricBlockCipher asymmetricBlockCipher = this.createAsymmetricWrapper(this.getAlgorithmIdentifier().getAlgorithm());
        CipherParameters cipherParameters = this.publicKey;
        if (this.random != null) {
            cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
        }
        try {
            byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
            asymmetricBlockCipher.init(true, cipherParameters);
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new OperatorException("unable to encrypt contents key", invalidCipherTextException);
        }
    }

    protected abstract AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier var1);
}

