/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import com.easywebmap.shaded.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.easywebmap.shaded.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPrivateKey;
import com.easywebmap.shaded.bouncycastle.jcajce.provider.asymmetric.elgamal.BCElGamalPublicKey;
import com.easywebmap.shaded.bouncycastle.jce.provider.BouncyCastleProvider;
import com.easywebmap.shaded.bouncycastle.jce.spec.ElGamalParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    ElGamalKeyGenerationParameters param;
    ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
    int strength = 1024;
    int certainty = 20;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ElGamal");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
        }
        if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
            ElGamalParameterSpec elGamalParameterSpec = (ElGamalParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(elGamalParameterSpec.getP(), elGamalParameterSpec.getG()));
        } else {
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = new ElGamalKeyGenerationParameters(secureRandom, new ElGamalParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), dHParameterSpec.getL()));
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        if (!this.initialised) {
            object2 = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
            if (object2 != null) {
                this.param = new ElGamalKeyGenerationParameters(this.random, new ElGamalParameters(((DHParameterSpec)object2).getP(), ((DHParameterSpec)object2).getG(), ((DHParameterSpec)object2).getL()));
            } else {
                object = new ElGamalParametersGenerator();
                ((ElGamalParametersGenerator)object).init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, ((ElGamalParametersGenerator)object).generateParameters());
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        object2 = this.engine.generateKeyPair();
        object = (ElGamalPublicKeyParameters)((AsymmetricCipherKeyPair)object2).getPublic();
        ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)((AsymmetricCipherKeyPair)object2).getPrivate();
        return new KeyPair(new BCElGamalPublicKey((ElGamalPublicKeyParameters)object), new BCElGamalPrivateKey(elGamalPrivateKeyParameters));
    }
}

