/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.its.bc;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1Encodable;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.nist.NISTNamedCurves;
import com.easywebmap.shaded.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import com.easywebmap.shaded.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.x9.X9ECParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECDomainParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.easywebmap.shaded.bouncycastle.its.ITSPublicEncryptionKey;
import com.easywebmap.shaded.bouncycastle.math.ec.ECCurve;
import com.easywebmap.shaded.bouncycastle.math.ec.ECPoint;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.BasePublicEncryptionKey;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.EccCurvePoint;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP384CurvePoint;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import com.easywebmap.shaded.bouncycastle.oer.its.ieee1609dot2.basetypes.SymmAlgorithm;

public class BcITSPublicEncryptionKey
extends ITSPublicEncryptionKey {
    public BcITSPublicEncryptionKey(PublicEncryptionKey publicEncryptionKey) {
        super(publicEncryptionKey);
    }

    static PublicEncryptionKey fromKeyParameters(ECPublicKeyParameters eCPublicKeyParameters) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = ((ECNamedDomainParameters)eCPublicKeyParameters.getParameters()).getName();
        ECPoint eCPoint = eCPublicKeyParameters.getQ();
        if (aSN1ObjectIdentifier.equals(SECObjectIdentifiers.secp256r1)) {
            return new PublicEncryptionKey(SymmAlgorithm.aes128Ccm, new BasePublicEncryptionKey.Builder().setChoice(0).setValue(EccP256CurvePoint.uncompressedP256(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger())).createBasePublicEncryptionKey());
        }
        if (aSN1ObjectIdentifier.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            return new PublicEncryptionKey(SymmAlgorithm.aes128Ccm, new BasePublicEncryptionKey.Builder().setChoice(1).setValue(EccP256CurvePoint.uncompressedP256(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger())).createBasePublicEncryptionKey());
        }
        throw new IllegalArgumentException("unknown curve in public encryption key");
    }

    public BcITSPublicEncryptionKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        super(BcITSPublicEncryptionKey.fromKeyParameters((ECPublicKeyParameters)asymmetricKeyParameter));
    }

    public AsymmetricKeyParameter getKey() {
        byte[] byArray;
        X9ECParameters x9ECParameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        BasePublicEncryptionKey basePublicEncryptionKey = this.encryptionKey.getPublicKey();
        switch (basePublicEncryptionKey.getChoice()) {
            case 0: {
                aSN1ObjectIdentifier = SECObjectIdentifiers.secp256r1;
                x9ECParameters = NISTNamedCurves.getByOID(SECObjectIdentifiers.secp256r1);
                break;
            }
            case 1: {
                aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.brainpoolP256r1;
                x9ECParameters = TeleTrusTNamedCurves.getByOID(TeleTrusTObjectIdentifiers.brainpoolP256r1);
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        ECCurve eCCurve = x9ECParameters.getCurve();
        ASN1Encodable aSN1Encodable = this.encryptionKey.getPublicKey().getBasePublicEncryptionKey();
        if (!(aSN1Encodable instanceof EccCurvePoint)) {
            throw new IllegalStateException("extension to public verification key not supported");
        }
        EccCurvePoint eccCurvePoint = (EccCurvePoint)basePublicEncryptionKey.getBasePublicEncryptionKey();
        if (eccCurvePoint instanceof EccP256CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else if (eccCurvePoint instanceof EccP384CurvePoint) {
            byArray = eccCurvePoint.getEncodedPoint();
        } else {
            throw new IllegalStateException("unknown key type");
        }
        ECPoint eCPoint = eCCurve.decodePoint(byArray).normalize();
        return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters));
    }
}

