/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.its.bc;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.crypto.Digest;
import com.easywebmap.shaded.bouncycastle.crypto.io.DigestOutputStream;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.crypto.signers.DSADigestSigner;
import com.easywebmap.shaded.bouncycastle.crypto.signers.ECDSASigner;
import com.easywebmap.shaded.bouncycastle.its.ITSCertificate;
import com.easywebmap.shaded.bouncycastle.its.operator.ITSContentSigner;
import com.easywebmap.shaded.bouncycastle.operator.OperatorCreationException;
import com.easywebmap.shaded.bouncycastle.operator.bc.BcDefaultDigestProvider;
import com.easywebmap.shaded.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

public class BcITSContentSigner
implements ITSContentSigner {
    private final ECPrivateKeyParameters privKey;
    private final ITSCertificate signerCert;
    private final AlgorithmIdentifier digestAlgo;
    private final Digest digest;
    private final byte[] parentData;
    private final ASN1ObjectIdentifier curveID;
    private final byte[] parentDigest;

    public BcITSContentSigner(ECPrivateKeyParameters eCPrivateKeyParameters) {
        this(eCPrivateKeyParameters, null);
    }

    public BcITSContentSigner(ECPrivateKeyParameters eCPrivateKeyParameters, ITSCertificate iTSCertificate) {
        this.privKey = eCPrivateKeyParameters;
        this.curveID = ((ECNamedDomainParameters)eCPrivateKeyParameters.getParameters()).getName();
        this.signerCert = iTSCertificate;
        if (this.curveID.equals(SECObjectIdentifiers.secp256r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        } else if (this.curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256);
        } else if (this.curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
            this.digestAlgo = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384);
        } else {
            throw new IllegalArgumentException("unknown key type");
        }
        try {
            this.digest = BcDefaultDigestProvider.INSTANCE.get(this.digestAlgo);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new IllegalStateException("cannot recognise digest type: " + this.digestAlgo.getAlgorithm());
        }
        if (iTSCertificate != null) {
            try {
                this.parentData = iTSCertificate.getEncoded();
                this.parentDigest = new byte[this.digest.getDigestSize()];
                this.digest.update(this.parentData, 0, this.parentData.length);
                this.digest.doFinal(this.parentDigest, 0);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("signer certificate encoding failed: " + iOException.getMessage());
            }
        } else {
            this.parentData = null;
            this.parentDigest = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(this.parentDigest, 0);
        }
    }

    @Override
    public ITSCertificate getAssociatedCertificate() {
        return this.signerCert;
    }

    @Override
    public byte[] getAssociatedCertificateDigest() {
        return Arrays.clone(this.parentDigest);
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgo;
    }

    @Override
    public OutputStream getOutputStream() {
        return new DigestOutputStream(this.digest);
    }

    @Override
    public boolean isForSelfSigning() {
        return this.parentData == null;
    }

    @Override
    public ASN1ObjectIdentifier getCurveID() {
        return this.curveID;
    }

    @Override
    public byte[] getSignature() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        DSADigestSigner dSADigestSigner = new DSADigestSigner(new ECDSASigner(), this.digest);
        dSADigestSigner.init(true, this.privKey);
        dSADigestSigner.update(byArray, 0, byArray.length);
        dSADigestSigner.update(this.parentDigest, 0, this.parentDigest.length);
        return dSADigestSigner.generateSignature();
    }
}

