/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.dvcs;

import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.CMSProcessableByteArray;
import com.easywebmap.shaded.bouncycastle.cms.CMSSignedData;
import com.easywebmap.shaded.bouncycastle.cms.CMSSignedDataGenerator;
import com.easywebmap.shaded.bouncycastle.dvcs.DVCSException;
import com.easywebmap.shaded.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

