/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.crypto.kems;

import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicePurpose;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import com.easywebmap.shaded.bouncycastle.crypto.DerivationFunction;
import com.easywebmap.shaded.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.SecretWithEncapsulation;
import com.easywebmap.shaded.bouncycastle.crypto.constraints.ConstraintUtils;
import com.easywebmap.shaded.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.easywebmap.shaded.bouncycastle.crypto.kems.SecretWithEncapsulationImpl;
import com.easywebmap.shaded.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.easywebmap.shaded.bouncycastle.crypto.params.KDFParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.RSAKeyParameters;
import com.easywebmap.shaded.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKEMGenerator
implements EncapsulatedSecretGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private final int keyLen;
    private DerivationFunction kdf;
    private SecureRandom rnd;

    public RSAKEMGenerator(int n, DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.keyLen = n;
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
        if (rSAKeyParameters.isPrivate()) {
            throw new IllegalArgumentException("public key required for encryption");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSAKem", ConstraintUtils.bitsOfSecurityFor(rSAKeyParameters.getModulus()), rSAKeyParameters, CryptoServicePurpose.ENCRYPTION));
        BigInteger bigInteger = rSAKeyParameters.getModulus();
        BigInteger bigInteger2 = rSAKeyParameters.getExponent();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(ZERO, bigInteger.subtract(ONE), this.rnd);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger4);
        return new SecretWithEncapsulationImpl(RSAKEMGenerator.generateKey(this.kdf, bigInteger, bigInteger3, this.keyLen), byArray);
    }

    static byte[] generateKey(DerivationFunction derivationFunction, BigInteger bigInteger, BigInteger bigInteger2, int n) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger2);
        derivationFunction.init(new KDFParameters(byArray, null));
        byte[] byArray2 = new byte[n];
        derivationFunction.generateBytes(byArray2, 0, byArray2.length);
        return byArray2;
    }
}

