/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.crypto.generators;

import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicePurpose;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import com.easywebmap.shaded.bouncycastle.crypto.KeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.crypto.constraints.ConstraintUtils;
import com.easywebmap.shaded.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.easywebmap.shaded.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.easywebmap.shaded.bouncycastle.crypto.params.DHParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (ElGamalKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("ElGamalKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters elGamalParameters = this.param.getParameters();
        DHParameters dHParameters = new DHParameters(elGamalParameters.getP(), elGamalParameters.getG(), null, elGamalParameters.getL());
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(bigInteger2, elGamalParameters), new ElGamalPrivateKeyParameters(bigInteger, elGamalParameters));
    }
}

