/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.crypto.generators;

import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.easywebmap.shaded.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicePurpose;
import com.easywebmap.shaded.bouncycastle.crypto.CryptoServicesRegistrar;
import com.easywebmap.shaded.bouncycastle.crypto.KeyGenerationParameters;
import com.easywebmap.shaded.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.easywebmap.shaded.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import java.security.SecureRandom;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed25519KeyGen", 128, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

