/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.crypto.ec;

import com.easywebmap.shaded.bouncycastle.crypto.CipherParameters;
import com.easywebmap.shaded.bouncycastle.crypto.ec.ECDecryptor;
import com.easywebmap.shaded.bouncycastle.crypto.ec.ECPair;
import com.easywebmap.shaded.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.easywebmap.shaded.bouncycastle.math.ec.ECAlgorithms;
import com.easywebmap.shaded.bouncycastle.math.ec.ECCurve;
import com.easywebmap.shaded.bouncycastle.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public ECPoint decrypt(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve eCCurve = this.key.getParameters().getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, eCPair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(eCCurve, eCPair.getY()).subtract(eCPoint).normalize();
    }
}

