/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.cms.jcajce;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1OctetString;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.RecipientOperator;
import com.easywebmap.shaded.bouncycastle.cms.jcajce.JceKeyAgreeRecipient;
import com.easywebmap.shaded.bouncycastle.jcajce.io.MacOutputStream;
import com.easywebmap.shaded.bouncycastle.operator.GenericKey;
import com.easywebmap.shaded.bouncycastle.operator.MacCalculator;
import com.easywebmap.shaded.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import javax.crypto.Mac;

public class JceKeyAgreeAuthenticatedRecipient
extends JceKeyAgreeRecipient {
    public JceKeyAgreeAuthenticatedRecipient(PrivateKey privateKey) {
        super(privateKey);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1OctetString aSN1OctetString, byte[] byArray) throws CMSException {
        final Key key = this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, subjectPublicKeyInfo, aSN1OctetString, byArray);
        final Mac mac = this.contentHelper.createContentMac(key, algorithmIdentifier2);
        return new RecipientOperator(new MacCalculator(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public GenericKey getKey() {
                return new JceGenericKey(algorithmIdentifier2, key);
            }

            @Override
            public OutputStream getOutputStream() {
                return new MacOutputStream(mac);
            }

            @Override
            public byte[] getMac() {
                return mac.doFinal();
            }
        });
    }
}

