/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.cms.jcajce;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1OctetString;
import com.easywebmap.shaded.bouncycastle.asn1.x500.X500Name;
import com.easywebmap.shaded.bouncycastle.cms.KeyTransRecipientId;
import com.easywebmap.shaded.bouncycastle.cms.SignerId;
import java.io.IOException;
import java.security.cert.X509CertSelector;

public class JcaSelectorConverter {
    public SignerId getSignerId(X509CertSelector x509CertSelector) {
        try {
            if (x509CertSelector.getSubjectKeyIdentifier() != null) {
                return new SignerId(X500Name.getInstance(x509CertSelector.getIssuerAsBytes()), x509CertSelector.getSerialNumber(), ASN1OctetString.getInstance(x509CertSelector.getSubjectKeyIdentifier()).getOctets());
            }
            return new SignerId(X500Name.getInstance(x509CertSelector.getIssuerAsBytes()), x509CertSelector.getSerialNumber());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to convert issuer: " + iOException.getMessage());
        }
    }

    public KeyTransRecipientId getKeyTransRecipientId(X509CertSelector x509CertSelector) {
        try {
            if (x509CertSelector.getSubjectKeyIdentifier() != null) {
                return new KeyTransRecipientId(X500Name.getInstance(x509CertSelector.getIssuerAsBytes()), x509CertSelector.getSerialNumber(), ASN1OctetString.getInstance(x509CertSelector.getSubjectKeyIdentifier()).getOctets());
            }
            return new KeyTransRecipientId(X500Name.getInstance(x509CertSelector.getIssuerAsBytes()), x509CertSelector.getSerialNumber());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("unable to convert issuer: " + iOException.getMessage());
        }
    }
}

