/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.cms;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1OctetString;
import com.easywebmap.shaded.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.easywebmap.shaded.bouncycastle.asn1.cms.KEMRecipientInfo;
import com.easywebmap.shaded.bouncycastle.asn1.cms.RecipientIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.CMSSecureReadable;
import com.easywebmap.shaded.bouncycastle.cms.KEMRecipient;
import com.easywebmap.shaded.bouncycastle.cms.KeyTransRecipientId;
import com.easywebmap.shaded.bouncycastle.cms.Recipient;
import com.easywebmap.shaded.bouncycastle.cms.RecipientInformation;
import com.easywebmap.shaded.bouncycastle.cms.RecipientOperator;

public class KEMRecipientInformation
extends RecipientInformation {
    private KEMRecipientInfo info;

    KEMRecipientInformation(KEMRecipientInfo kEMRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEMRecipientInfo.getKem(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEMRecipientInfo;
        RecipientIdentifier recipientIdentifier = kEMRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(this.keyEncAlg.getAlgorithm(), this.info), this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

