/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.cms;

import com.easywebmap.shaded.bouncycastle.asn1.cms.KEKIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.CMSSecureReadable;
import com.easywebmap.shaded.bouncycastle.cms.KEKRecipient;
import com.easywebmap.shaded.bouncycastle.cms.KEKRecipientId;
import com.easywebmap.shaded.bouncycastle.cms.Recipient;
import com.easywebmap.shaded.bouncycastle.cms.RecipientInformation;
import com.easywebmap.shaded.bouncycastle.cms.RecipientOperator;
import java.io.IOException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

