/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.cms;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Set;
import com.easywebmap.shaded.bouncycastle.asn1.DEROctetString;
import com.easywebmap.shaded.bouncycastle.asn1.DERSet;
import com.easywebmap.shaded.bouncycastle.asn1.cms.AuthEnvelopedData;
import com.easywebmap.shaded.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.easywebmap.shaded.bouncycastle.asn1.cms.ContentInfo;
import com.easywebmap.shaded.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.easywebmap.shaded.bouncycastle.cms.CMSAuthEnvelopedData;
import com.easywebmap.shaded.bouncycastle.cms.CMSAuthEnvelopedGenerator;
import com.easywebmap.shaded.bouncycastle.cms.CMSException;
import com.easywebmap.shaded.bouncycastle.cms.CMSTypedData;
import com.easywebmap.shaded.bouncycastle.cms.CMSUtils;
import com.easywebmap.shaded.bouncycastle.operator.OutputAEADEncryptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CMSAuthEnvelopedDataGenerator
extends CMSAuthEnvelopedGenerator {
    private CMSAuthEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        ASN1Set aSN1Set;
        Object object;
        ASN1EncodableVector aSN1EncodableVector = CMSUtils.getRecipentInfos(outputAEADEncryptor.getKey(), this.recipientInfoGenerators);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputAEADEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            aSN1Set = CMSUtils.processAuthAttrSet(this.authAttrsGenerator, outputAEADEncryptor);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("unable to process authenticated content: " + iOException.getMessage(), iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        byte[] byArray = outputAEADEncryptor.getMAC();
        EncryptedContentInfo encryptedContentInfo = CMSUtils.getEncryptedContentInfo(cMSTypedData, outputAEADEncryptor, (byte[])object);
        ASN1Set aSN1Set2 = CMSUtils.getAttrDLSet(this.unauthAttrsGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.authEnvelopedData, new AuthEnvelopedData(this.originatorInfo, new DERSet(aSN1EncodableVector), encryptedContentInfo, aSN1Set, new DEROctetString(byArray), aSN1Set2));
        return new CMSAuthEnvelopedData(contentInfo);
    }

    public CMSAuthEnvelopedData generate(CMSTypedData cMSTypedData, OutputAEADEncryptor outputAEADEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputAEADEncryptor);
    }
}

