/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.asn1.nist;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Integer;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Object;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1OctetString;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Primitive;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Sequence;
import com.easywebmap.shaded.bouncycastle.asn1.DEROctetString;
import com.easywebmap.shaded.bouncycastle.asn1.DERSequence;
import com.easywebmap.shaded.bouncycastle.util.Arrays;

public class KMACwithSHAKE128_params
extends ASN1Object {
    private static final byte[] EMPTY_STRING = new byte[0];
    private static final int DEF_LENGTH = 256;
    private final int outputLength;
    private final byte[] customizationString;

    public KMACwithSHAKE128_params(int n) {
        this.outputLength = n;
        this.customizationString = EMPTY_STRING;
    }

    public KMACwithSHAKE128_params(int n, byte[] byArray) {
        this.outputLength = n;
        this.customizationString = Arrays.clone(byArray);
    }

    public static KMACwithSHAKE128_params getInstance(Object object) {
        if (object instanceof KMACwithSHAKE128_params) {
            return (KMACwithSHAKE128_params)object;
        }
        if (object != null) {
            return new KMACwithSHAKE128_params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private KMACwithSHAKE128_params(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("sequence size greater than 2");
        }
        if (aSN1Sequence.size() == 2) {
            this.outputLength = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
            this.customizationString = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        } else if (aSN1Sequence.size() == 1) {
            if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
                this.outputLength = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).intValueExact();
                this.customizationString = EMPTY_STRING;
            } else {
                this.outputLength = 256;
                this.customizationString = Arrays.clone(ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0)).getOctets());
            }
        } else {
            this.outputLength = 256;
            this.customizationString = EMPTY_STRING;
        }
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public byte[] getCustomizationString() {
        return Arrays.clone(this.customizationString);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.outputLength != 256) {
            aSN1EncodableVector.add(new ASN1Integer(this.outputLength));
        }
        if (this.customizationString.length != 0) {
            aSN1EncodableVector.add(new DEROctetString(this.getCustomizationString()));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

